/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.implementation.TestRunMetrics;
import java.lang.reflect.Method;
import java.util.Objects;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AzureTestWatcher
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public void beforeTestExecution(ExtensionContext extensionContext) {
        String displayName = extensionContext.getDisplayName();
        String testName = "";
        String fullyQualifiedTestName = "";
        if (extensionContext.getTestMethod().isPresent()) {
            Method method = (Method)extensionContext.getTestMethod().get();
            testName = method.getName();
            fullyQualifiedTestName = method.getDeclaringClass().getName() + "." + testName;
        }
        StringBuilder logPrefixBuilder = new StringBuilder("Starting test ").append(fullyQualifiedTestName);
        if (!Objects.equals(displayName, testName)) {
            logPrefixBuilder.append("(").append(displayName).append(")");
        }
        logPrefixBuilder.append(",");
        AzureTestWatcher.getStore(extensionContext).put((Object)extensionContext.getRequiredTestMethod(), (Object)new TestRunMetrics(logPrefixBuilder.toString(), System.currentTimeMillis()));
    }

    public void afterTestExecution(ExtensionContext context) {
        TestRunMetrics testInformation = (TestRunMetrics)AzureTestWatcher.getStore(context).remove((Object)context.getRequiredTestMethod(), TestRunMetrics.class);
        long duration = System.currentTimeMillis() - testInformation.getStartMillis();
        System.out.printf("%s completed in %d ms.%n", testInformation.getLogPrefix(), duration);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{AzureTestWatcher.class, context}));
    }
}

