/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.implementation.ImplUtils;
import com.azure.core.test.implementation.TestIterationContext;
import com.azure.core.test.utils.TestResourceNamer;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class TestBase
implements BeforeEachCallback {
    private static final String AZURE_TEST_MODE = "AZURE_TEST_MODE";
    private static final String AZURE_TEST_HTTP_CLIENTS = "AZURE_TEST_HTTP_CLIENTS";
    public static final String AZURE_TEST_HTTP_CLIENTS_VALUE_ALL = "ALL";
    public static final String AZURE_TEST_HTTP_CLIENTS_VALUE_NETTY = "NettyAsyncHttpClient";
    public static final String AZURE_TEST_SERVICE_VERSIONS_VALUE_ALL = "ALL";
    private static TestMode testMode;
    private final ClientLogger logger = new ClientLogger(TestBase.class);
    protected InterceptorManager interceptorManager;
    protected TestResourceNamer testResourceNamer;
    protected TestContextManager testContextManager;
    private ExtensionContext extensionContext;
    @RegisterExtension
    final TestIterationContext testIterationContext = new TestIterationContext();

    @BeforeAll
    public static void setupClass() {
        testMode = TestBase.initializeTestMode();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    @BeforeEach
    public void setupTest(TestInfo testInfo) {
        this.testContextManager = new TestContextManager((Method)testInfo.getTestMethod().get(), testMode);
        this.testContextManager.setTestIteration(this.testIterationContext.getTestIteration());
        this.logger.info("Test Mode: {}, Name: {}", new Object[]{testMode, this.testContextManager.getTestName()});
        try {
            this.interceptorManager = new InterceptorManager(this.testContextManager);
        }
        catch (UncheckedIOException e) {
            this.logger.error("Could not create interceptor for {}", new Object[]{this.testContextManager.getTestName(), e});
            Assertions.fail((Throwable)e);
        }
        this.testResourceNamer = new TestResourceNamer(this.testContextManager, this.interceptorManager.getRecordedData());
        this.beforeTest();
    }

    @AfterEach
    public void teardownTest(TestInfo testInfo) {
        if (this.testContextManager != null && this.testContextManager.didTestRun()) {
            this.afterTest();
            this.interceptorManager.close();
        }
    }

    public TestMode getTestMode() {
        return testMode;
    }

    @Deprecated
    protected String getTestName() {
        if (this.extensionContext != null) {
            return this.extensionContext.getTestMethod().map(Method::getName).orElse(null);
        }
        return null;
    }

    protected void beforeTest() {
    }

    protected void afterTest() {
    }

    public static Stream<HttpClient> getHttpClients() {
        return testMode == TestMode.PLAYBACK ? Stream.of(new HttpClient[]{null}) : StreamSupport.stream(ServiceLoader.load(HttpClientProvider.class).spliterator(), false).map(HttpClientProvider::createInstance).filter(TestBase::shouldClientBeTested);
    }

    public static boolean shouldClientBeTested(HttpClient client) {
        String configuredHttpClientToTest = Configuration.getGlobalConfiguration().get(AZURE_TEST_HTTP_CLIENTS);
        if (CoreUtils.isNullOrEmpty((CharSequence)configuredHttpClientToTest)) {
            return client.getClass().getSimpleName().equals(AZURE_TEST_HTTP_CLIENTS_VALUE_NETTY);
        }
        if (configuredHttpClientToTest.equalsIgnoreCase("ALL")) {
            return true;
        }
        String[] configuredHttpClientList = configuredHttpClientToTest.split(",");
        return Arrays.stream(configuredHttpClientList).anyMatch(configuredHttpClient -> client.getClass().getSimpleName().toLowerCase(Locale.ROOT).contains(configuredHttpClient.trim().toLowerCase(Locale.ROOT)));
    }

    static TestMode initializeTestMode() {
        return ImplUtils.getTestMode();
    }

    protected void sleepIfRunningAgainstService(long millis) {
        if (testMode == TestMode.PLAYBACK) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalStateException(ex));
        }
    }
}

