/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.utils.ResourceNamer;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class TestResourceNamer
extends ResourceNamer {
    private final RecordedData recordedData;
    private final boolean allowedToReadRecordedValues;
    private final boolean allowedToRecordValues;

    @Deprecated
    public TestResourceNamer(String name, TestMode testMode, RecordedData recordedData) {
        this(name, testMode, false, recordedData);
    }

    public TestResourceNamer(TestContextManager testContextManager, RecordedData recordedData) {
        this(testContextManager.getTestName(), testContextManager.getTestMode(), testContextManager.doNotRecordTest(), recordedData);
    }

    private TestResourceNamer(String name, TestMode testMode, boolean doNotRecord, RecordedData recordedData) {
        super(name);
        if (testMode != TestMode.LIVE && !doNotRecord) {
            Objects.requireNonNull(recordedData, "'recordedData' cannot be null.");
        }
        this.recordedData = recordedData;
        this.allowedToReadRecordedValues = testMode == TestMode.PLAYBACK && !doNotRecord;
        this.allowedToRecordValues = testMode == TestMode.RECORD && !doNotRecord;
    }

    @Override
    public String randomName(String prefix, int maxLen) {
        return this.getValue(readValue -> readValue, () -> super.randomName(prefix, maxLen));
    }

    @Override
    public String randomUuid() {
        return this.getValue(readValue -> readValue, () -> super.randomUuid());
    }

    public OffsetDateTime now() {
        return this.getValue(OffsetDateTime::parse, () -> OffsetDateTime.now(ZoneOffset.UTC));
    }

    public String recordValueFromConfig(String value) {
        return this.getValue(readValue -> readValue, () -> value);
    }

    private <T> T getValue(Function<String, T> readHandler, Supplier<T> valueSupplier) {
        if (this.allowedToReadRecordedValues) {
            return readHandler.apply(this.recordedData.removeVariable());
        }
        T value = valueSupplier.get();
        if (this.allowedToRecordValues) {
            this.recordedData.addVariable(value.toString());
        }
        return value;
    }
}

