/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation;

import com.azure.core.test.TestMode;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;

public final class ImplUtils {
    public static final String AZURE_TEST_MODE = "AZURE_TEST_MODE";

    public static TestMode getTestMode() {
        ClientLogger logger = new ClientLogger(ImplUtils.class);
        String azureTestMode = Configuration.getGlobalConfiguration().get(AZURE_TEST_MODE);
        if (azureTestMode != null) {
            try {
                return TestMode.valueOf(azureTestMode.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                logger.error("Could not parse '{}' into TestEnum. Using 'Playback' mode.", new Object[]{azureTestMode});
                return TestMode.PLAYBACK;
            }
        }
        logger.info("Environment variable '{}' has not been set yet. Using 'Playback' mode.", new Object[]{AZURE_TEST_MODE});
        return TestMode.PLAYBACK;
    }
}

