/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.models;

import com.azure.core.test.models.NetworkCallRecord;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Predicate;

public class RecordedData {
    @JsonProperty
    private final LinkedList<NetworkCallRecord> networkCallRecords = new LinkedList();
    @JsonProperty
    private final LinkedList<String> variables = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkCallRecord findFirstAndRemoveNetworkCall(Predicate<NetworkCallRecord> isMatch) {
        Objects.requireNonNull(isMatch, "'isMatch' cannot be null.");
        LinkedList<NetworkCallRecord> linkedList = this.networkCallRecords;
        synchronized (linkedList) {
            Iterator iterator = this.networkCallRecords.iterator();
            while (iterator.hasNext()) {
                NetworkCallRecord next = (NetworkCallRecord)iterator.next();
                if (!isMatch.test(next)) continue;
                iterator.remove();
                return next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkCall(NetworkCallRecord record) {
        Objects.requireNonNull(record, "'record' cannot be null.");
        LinkedList<NetworkCallRecord> linkedList = this.networkCallRecords;
        synchronized (linkedList) {
            this.networkCallRecords.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariable(String variable) {
        Objects.requireNonNull(variable, "'variable' cannot be null.");
        LinkedList<String> linkedList = this.variables;
        synchronized (linkedList) {
            this.variables.add(variable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeVariable() {
        LinkedList<String> linkedList = this.variables;
        synchronized (linkedList) {
            return this.variables.remove();
        }
    }
}

