/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.nio.charset.StandardCharsets;

public class HttpClientTestsWireMockServer {
    private static final String PLAIN_RESPONSE = "/plainBytesNoHeader";
    private static final String HEADER_RESPONSE = "/plainBytesWithHeader";
    private static final String INVALID_HEADER_RESPONSE = "/plainBytesInvalidHeader";
    private static final String UTF_8_BOM_RESPONSE = "/utf8BomBytes";
    private static final String UTF_16BE_BOM_RESPONSE = "/utf16BeBomBytes";
    private static final String UTF_16LE_BOM_RESPONSE = "/utf16LeBomBytes";
    private static final String UTF_32BE_BOM_RESPONSE = "/utf32BeBomBytes";
    private static final String UTF_32LE_BOM_RESPONSE = "/utf32LeBomBytes";
    private static final String BOM_WITH_SAME_HEADER = "/bomBytesWithSameHeader";
    private static final String BOM_WITH_DIFFERENT_HEADER = "/bomBytesWithDifferentHeader";
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF_16BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};
    private static final byte[] UTF_32BE_BOM = new byte[]{0, 0, -2, -1};
    private static final byte[] UTF_32LE_BOM = new byte[]{-1, -2, 0, 0};
    private static final byte[] RETURN_BYTES = "Hello World!".getBytes(StandardCharsets.UTF_8);

    public static WireMockServer getHttpClientTestsServer() {
        WireMockServer server = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().disableRequestJournal().gzipDisabled(true));
        server.stubFor(WireMock.get((String)PLAIN_RESPONSE).willReturn(WireMock.aResponse().withBody(RETURN_BYTES)));
        server.stubFor(WireMock.get((String)HEADER_RESPONSE).willReturn(WireMock.aResponse().withBody(RETURN_BYTES).withHeader("Content-Type", new String[]{"charset=UTF-16BE"})));
        server.stubFor(WireMock.get((String)INVALID_HEADER_RESPONSE).willReturn(WireMock.aResponse().withBody(RETURN_BYTES).withHeader("Content-Type", new String[]{"charset=invalid"})));
        server.stubFor(WireMock.get((String)UTF_8_BOM_RESPONSE).willReturn(WireMock.aResponse().withBody(HttpClientTestsWireMockServer.addBom(UTF_8_BOM))));
        server.stubFor(WireMock.get((String)UTF_16BE_BOM_RESPONSE).willReturn(WireMock.aResponse().withBody(HttpClientTestsWireMockServer.addBom(UTF_16BE_BOM))));
        server.stubFor(WireMock.get((String)UTF_16LE_BOM_RESPONSE).willReturn(WireMock.aResponse().withBody(HttpClientTestsWireMockServer.addBom(UTF_16LE_BOM))));
        server.stubFor(WireMock.get((String)UTF_32BE_BOM_RESPONSE).willReturn(WireMock.aResponse().withBody(HttpClientTestsWireMockServer.addBom(UTF_32BE_BOM))));
        server.stubFor(WireMock.get((String)UTF_32LE_BOM_RESPONSE).willReturn(WireMock.aResponse().withBody(HttpClientTestsWireMockServer.addBom(UTF_32LE_BOM))));
        server.stubFor(WireMock.get((String)BOM_WITH_SAME_HEADER).willReturn(WireMock.aResponse().withBody(HttpClientTestsWireMockServer.addBom(UTF_8_BOM)).withHeader("Content-Type", new String[]{"charset=UTF-8"})));
        server.stubFor(WireMock.get((String)BOM_WITH_DIFFERENT_HEADER).willReturn(WireMock.aResponse().withBody(HttpClientTestsWireMockServer.addBom(UTF_8_BOM)).withHeader("Content-Type", new String[]{"charset=UTF-16"})));
        return server;
    }

    private static byte[] addBom(byte[] arr1) {
        byte[] mergedArray = new byte[arr1.length + RETURN_BYTES.length];
        System.arraycopy(arr1, 0, mergedArray, 0, arr1.length);
        System.arraycopy(RETURN_BYTES, 0, mergedArray, arr1.length, RETURN_BYTES.length);
        return mergedArray;
    }
}

