/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.models.RecordingRedactor;
import com.azure.core.util.CoreUtils;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class RecordingRedactorTests {
    private static final String DUMMY_SENSITIVE_INFORMATION = "sensitiveInformation";
    private static final String NON_SENSITIVE_DATA_CONTENT = "\"Response\" : {\n      \"Body\" : \"{\"a\":\"a\",\"expirationDateTimeTicks\":637270217074441783}\",\n    },";
    private static final String ACCESS_TOKEN_FIRST_PAIR = "\"Response\" : {\n      \"Body\" : \"{\"accessToken\":\"sensitiveData\",\"expirationDateTimeTicks\":637270217074441783}\",\n    },";
    private static final String EXPECTED_ACCESS_TOKEN_FIRST_PAIR_REDACTED = "\"Response\" : {\n      \"Body\" : \"{\"accessToken\":\"REDACTED\",\"expirationDateTimeTicks\":637270217074441783}\",\n    },";
    private static final String ACCESS_TOKEN_LAST_PAIR = "\"Response\" : {\n      \"Body\" : \"{\"accessToken\":\"sensitiveData\"}\",\n    },";
    private static final String EXPECTED_ACCESS_TOKEN_LAST_PAIR_REDACTED = "\"Response\" : {\n      \"Body\" : \"{\"accessToken\":\"REDACTED\"}\",\n    },";
    private static final String USER_DELEGATION_KEY_FOR_VALUE_RESPONSE = "\"Response\" : {\n   \"Body\" : <UserDelegationKey><Value>sensitiveInformation=</Value></UserDelegationKey>\",\n    },";
    private static final String EXPECTED_USER_DELEGATION_KEY_FOR_VALUE_RESPONSE_REDACTED = "\"Response\" : {\n   \"Body\" : <UserDelegationKey><Value>UkVEQUNURUQ=</Value></UserDelegationKey>\",\n    },";
    private static final String USER_DELEGATION_KEY_FOR_SIGNED_OID_RESPONSE = "\"Response\" : {\n   \"Body\" : <UserDelegationKey><SignedOid>sensitiveInformation=</SignedOid></UserDelegationKey>\",\n    },";
    private static final String USER_DELEGATION_KEY_FOR_SIGNED_TID_RESPONSE = "\"Response\" : {\n   \"Body\" : <UserDelegationKey><SignedTid>sensitiveInformation</SignedTid></UserDelegationKey>\",\n    },";
    private static final String CONNECTION_STRING_RESPONSE_BODY = "\"dataSourceParameter\":{\"connectionString\":\"Server=test-sample.db.windows.net,1433;Initial =sample;MultipleActive;Encrypt=True;Connection Timeout=30;\",\"query\":\"select * from adsample2 where Timestamp = @StartTime\"";
    private static final String REDACTED_CONNECTION_STRING_RESPONSE = "\"dataSourceParameter\":{\"connectionString\":\"REDACTED\",\"query\":\"select * from adsample2 where Timestamp = @StartTime\"";
    private static final String USERNAME_RESPONSE_BODY = "\"dataSourceParameter\":{\"query\":\"select * from adsample2 where Timestamp = @StartTime\";User ID=testUser1;\"userName\":\"testUser\"}";
    private static final String REDACTED_USERNAME_RESPONSE = "\"dataSourceParameter\":{\"query\":\"select * from adsample2 where Timestamp = @StartTime\";User ID=REDACTED;\"userName\":\"REDACTED\"}";
    private static final String PASSWORD_RESPONSE_BODY = "\"dataSourceParameter\":{\"query\":\"select * from adsample2 where Timestamp = @StartTime\";\"password\":\"testUserPwd\",Password=testPWD;";
    private static final String REDACTED_PASSWORD_RESPONSE_BODY = "\"dataSourceParameter\":{\"query\":\"select * from adsample2 where Timestamp = @StartTime\";\"password\":\"REDACTED\",Password=REDACTED;";
    private static final String APPLICATION_ID_RESPONSE_BODY = "\"dataSourceParameter\":{\"query\":\"select * from adsample2 where Timestamp = @StartTime\";\"applicationId\":\"app_insights_app_id\"}";
    private static final String REDACTED_APPLICATION_ID_RESPONSE_BODY = "\"dataSourceParameter\":{\"query\":\"select * from adsample2 where Timestamp = @StartTime\";\"applicationId\":\"REDACTED\"}";
    private static final String API_ID_RESPONSE_BODY = "\"dataSourceParameter\":{\"apiKey\":\"api_key\",;\"applicationId\":\"APP_INSIGHT_APP_ID\"}";
    private static final String REDACTED_API_ID_RESPONSE_BODY = "\"dataSourceParameter\":{\"apiKey\":\"REDACTED\",;\"applicationId\":\"REDACTED\"}";
    private static final String HTTP_URL_RESPONSE_BODY = "\"dataSourceParameter\":{\"httpMethod\":\"GET\",\"url\":\"http://url\"}";
    private static final String REDACTED_HTTP_URL_RESPONSE_BODY = "\"dataSourceParameter\":{\"httpMethod\":\"GET\",\"url\":\"REDACTED\"}";
    private static final String HOST_RESPONSE_BODY = "\"dataSourceParameter\":{\"port\":\"9200\",\"query\":\"select * from adsample2 where Timestamp = @StartTime\",\"host\":\"host.azure.com\"}";
    private static final String REDACTED_HOST_RESPONSE_BODY = "\"dataSourceParameter\":{\"port\":\"9200\",\"query\":\"select * from adsample2 where Timestamp = @StartTime\",\"host\":\"REDACTED\"}";
    private static final String ACCOUNT_NAME_RESPONSE_BODY = "\"dataSourceParameter\":{\"fileTemplate\":\"adsample.json\",\"accountName\":\"sampleAccountName\",\"directoryTemplate\":\"%Y/%m/%d\"}";
    private static final String REDACTED_ACCOUNT_NAME_RESPONSE_BODY = "\"dataSourceParameter\":{\"fileTemplate\":\"adsample.json\",\"accountName\":\"REDACTED\",\"directoryTemplate\":\"%Y/%m/%d\"}";
    private static final String ACCOUNT_KEY_RESPONSE_BODY = "\"dataSourceParameter\":{\"fileSystemName\":\"adsample\",\"accountKey\":\"Pi5n+zrzyZZEtSjFoamPe622ZsmwiOZzdPvRKpvmuzxSC+tA==\"}";
    private static final String REDACTED_ACCOUNT_KEY_RESPONSE_BODY = "\"dataSourceParameter\":{\"fileSystemName\":\"adsample\",\"accountKey\":\"REDACTED\"}";
    private static final String AUTH_HEADER_RESPONSE_BODY = "\"dataSourceParameter\":{\"authHeader\":\"XYZ\",\"port\":\"9200\"";
    private static final String REDACTED_AUTH_HEADER_RESPONSE_BODY = "\"dataSourceParameter\":{\"authHeader\":\"REDACTED\",\"port\":\"9200\"";
    private static final String EMPTY_KEY_RESPONSE_BODY = "\"dataSourceParameter\":{\"username\":\"\",\"port\":\"9200\"";
    private static final String REDACTED_EMPTY_KEY_RESPONSE_BODY = "\"dataSourceParameter\":{\"username\":\"\",\"port\":\"9200\"";
    private static final String PII_RESPONSE_DATA = "\"name\":\"Foo\", \"ssn\":\"123-45-6789\"";
    private static final String REDACTED_PII_RESPONSE_DATA = "\"name\":\"Foo\", \"ssn\":\"REDACTED\"";

    @ParameterizedTest
    @MethodSource(value={"sensitiveDataSupplier"})
    public void redactSensitiveContent(String sensitiveData, String redactedContent) {
        Assertions.assertEquals((Object)redactedContent, (Object)new RecordingRedactor().redact(sensitiveData));
    }

    @Test
    public void replaceUserDelegationKeyForSignedOidTag() {
        Assertions.assertFalse((boolean)new RecordingRedactor().redact(USER_DELEGATION_KEY_FOR_SIGNED_OID_RESPONSE).contains(DUMMY_SENSITIVE_INFORMATION));
    }

    @Test
    public void replaceUserDelegationKeyForSignedTidTag() {
        Assertions.assertFalse((boolean)new RecordingRedactor().redact(USER_DELEGATION_KEY_FOR_SIGNED_TID_RESPONSE).contains(DUMMY_SENSITIVE_INFORMATION));
    }

    @Test
    public void customRedactor() {
        Pattern pattern = Pattern.compile("(.*\"ssn\":)(\"[-0-9]{11}\")");
        ArrayList<Function<String, String>> redactors = new ArrayList<Function<String, String>>();
        redactors.add(data -> this.redact((String)data, pattern.matcher((CharSequence)data), "\"REDACTED\""));
        RecordingRedactor recordingRedactor = new RecordingRedactor(redactors);
        Assertions.assertEquals((Object)recordingRedactor.redact(PII_RESPONSE_DATA), (Object)REDACTED_PII_RESPONSE_DATA);
    }

    private String redact(String content, Matcher matcher, String replacement) {
        while (matcher.find()) {
            String captureGroup = matcher.group(2);
            if (CoreUtils.isNullOrEmpty((CharSequence)captureGroup)) continue;
            content = content.replace(matcher.group(2), replacement);
        }
        return content;
    }

    private static Stream<Arguments> sensitiveDataSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{NON_SENSITIVE_DATA_CONTENT, NON_SENSITIVE_DATA_CONTENT}), Arguments.of((Object[])new Object[]{API_ID_RESPONSE_BODY, REDACTED_API_ID_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{AUTH_HEADER_RESPONSE_BODY, REDACTED_AUTH_HEADER_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{ACCOUNT_NAME_RESPONSE_BODY, REDACTED_ACCOUNT_NAME_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{ACCOUNT_KEY_RESPONSE_BODY, REDACTED_ACCOUNT_KEY_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{ACCESS_TOKEN_LAST_PAIR, EXPECTED_ACCESS_TOKEN_LAST_PAIR_REDACTED}), Arguments.of((Object[])new Object[]{ACCESS_TOKEN_FIRST_PAIR, EXPECTED_ACCESS_TOKEN_FIRST_PAIR_REDACTED}), Arguments.of((Object[])new Object[]{APPLICATION_ID_RESPONSE_BODY, REDACTED_APPLICATION_ID_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{CONNECTION_STRING_RESPONSE_BODY, REDACTED_CONNECTION_STRING_RESPONSE}), Arguments.of((Object[])new Object[]{HTTP_URL_RESPONSE_BODY, REDACTED_HTTP_URL_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{HOST_RESPONSE_BODY, REDACTED_HOST_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{USER_DELEGATION_KEY_FOR_VALUE_RESPONSE, EXPECTED_USER_DELEGATION_KEY_FOR_VALUE_RESPONSE_REDACTED}), Arguments.of((Object[])new Object[]{PASSWORD_RESPONSE_BODY, REDACTED_PASSWORD_RESPONSE_BODY}), Arguments.of((Object[])new Object[]{USERNAME_RESPONSE_BODY, REDACTED_USERNAME_RESPONSE}), Arguments.of((Object[])new Object[]{"\"dataSourceParameter\":{\"username\":\"\",\"port\":\"9200\"", "\"dataSourceParameter\":{\"username\":\"\",\"port\":\"9200\""}), Arguments.of((Object[])new Object[]{NON_SENSITIVE_DATA_CONTENT, NON_SENSITIVE_DATA_CONTENT}));
    }

    @Test
    public void replaceUrlKey() {
        Assertions.assertEquals((Object)REDACTED_ACCOUNT_KEY_RESPONSE_BODY, (Object)new RecordingRedactor().redact(ACCOUNT_KEY_RESPONSE_BODY));
        Assertions.assertEquals((Object)REDACTED_AUTH_HEADER_RESPONSE_BODY, (Object)new RecordingRedactor().redact(AUTH_HEADER_RESPONSE_BODY));
    }
}

