/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.implementation.entities.HttpBinFormDataJSON;
import com.azure.core.test.implementation.entities.HttpBinJSON;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.net.URL;
import java.security.SecureRandom;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class RestProxyTestsWireMockServer {
    private static final JacksonAdapter JACKSON_ADAPTER = new JacksonAdapter();

    public static WireMockServer getRestProxyTestsServer() {
        WireMockServer server = new WireMockServer((Options)WireMockConfiguration.options().extensions(new Extension[]{new RestProxyResponseTransformer()}).dynamicPort().disableRequestJournal().gzipDisabled(true));
        server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/bytes/\\d+")));
        server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/anything.*")));
        server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/status/\\d+")));
        server.stubFor(WireMock.post((String)"post"));
        server.stubFor(WireMock.put((String)"put"));
        server.stubFor(WireMock.head((UrlPattern)WireMock.urlPathMatching((String)"/anything")));
        server.stubFor(WireMock.delete((String)"delete"));
        server.stubFor(WireMock.patch((UrlPattern)WireMock.urlPathMatching((String)"/patch")));
        server.stubFor(WireMock.get((String)"/get"));
        return server;
    }

    private static final class RestProxyResponseTransformer
    extends ResponseDefinitionTransformer {
        private RestProxyResponseTransformer() {
        }

        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource fileSource, Parameters parameters) {
            try {
                URL url = new URL(request.getAbsoluteUrl());
                String urlPath = url.getPath();
                if (urlPath.startsWith("/bytes")) {
                    return RestProxyResponseTransformer.createBytesResponse(urlPath);
                }
                if (urlPath.startsWith("/status")) {
                    return RestProxyResponseTransformer.createStatusResponse(urlPath);
                }
                if (urlPath.startsWith("/post")) {
                    if ("application/x-www-form-urlencoded".equalsIgnoreCase(request.getHeader("Content-Type"))) {
                        return RestProxyResponseTransformer.createFormResponse(request);
                    }
                    return RestProxyResponseTransformer.createSimpleHttpBinResponse(request, url);
                }
                if (urlPath.startsWith("/anything") || urlPath.startsWith("/put") || urlPath.startsWith("/delete") || urlPath.startsWith("/patch") || urlPath.startsWith("/get")) {
                    return RestProxyResponseTransformer.createSimpleHttpBinResponse(request, url);
                }
                return responseDefinition;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static ResponseDefinition createBytesResponse(String urlPath) {
            int bodySize = Integer.parseInt(urlPath.split("/", 3)[2]);
            Map<String, String> rawHeaders = RestProxyResponseTransformer.getBaseHttpHeaders();
            rawHeaders.put("Content-Type", "application/octet-stream");
            rawHeaders.put("Content-Length", String.valueOf(bodySize));
            byte[] body = new byte[bodySize];
            new SecureRandom().nextBytes(body);
            return new ResponseDefinitionBuilder().withStatus(200).withHeaders(RestProxyResponseTransformer.toWireMockHeaders(rawHeaders)).withBody(body).build();
        }

        private static ResponseDefinition createSimpleHttpBinResponse(Request request, URL url) throws IOException {
            HttpBinJSON responseBody = new HttpBinJSON();
            responseBody.url(RestProxyResponseTransformer.cleanseUrl(url));
            responseBody.data((Object)request.getBodyAsString());
            if (request.getHeaders() != null) {
                responseBody.headers(request.getHeaders().all().stream().collect(Collectors.toMap(MultiValue::key, MultiValue::values)));
            }
            return new ResponseDefinitionBuilder().withStatus(200).withHeaders(RestProxyResponseTransformer.toWireMockHeaders(RestProxyResponseTransformer.getBaseHttpHeaders())).withBody(JACKSON_ADAPTER.serialize((Object)responseBody, SerializerEncoding.JSON)).build();
        }

        private static ResponseDefinition createStatusResponse(String urlPath) {
            return new ResponseDefinitionBuilder().withStatus(Integer.parseInt(urlPath.split("/", 3)[2])).build();
        }

        private static ResponseDefinition createFormResponse(Request request) throws IOException {
            HttpBinFormDataJSON formBody = new HttpBinFormDataJSON();
            HttpBinFormDataJSON.Form form = new HttpBinFormDataJSON.Form();
            ArrayList<String> toppings = new ArrayList<String>();
            block14: for (String formKvp : request.getBodyAsString().split("&")) {
                String[] kvpPieces = formKvp.split("=");
                switch (kvpPieces[0]) {
                    case "custname": {
                        form.customerName(kvpPieces[1]);
                        continue block14;
                    }
                    case "custtel": {
                        form.customerTelephone(kvpPieces[1]);
                        continue block14;
                    }
                    case "custemail": {
                        form.customerEmail(kvpPieces[1]);
                        continue block14;
                    }
                    case "size": {
                        form.pizzaSize(HttpBinFormDataJSON.PizzaSize.valueOf((String)kvpPieces[1]));
                        continue block14;
                    }
                    case "toppings": {
                        toppings.add(kvpPieces[1]);
                        continue block14;
                    }
                }
            }
            form.toppings(toppings);
            formBody.form(form);
            return new ResponseDefinitionBuilder().withStatus(200).withBody(JACKSON_ADAPTER.serialize((Object)formBody, SerializerEncoding.JSON)).build();
        }

        private static String cleanseUrl(URL url) {
            StringBuilder builder = new StringBuilder();
            builder.append(url.getProtocol()).append("://").append(url.getHost()).append(url.getPath().replace("%20", " "));
            if (url.getQuery() != null) {
                builder.append("?").append(url.getQuery().replace("%20", " "));
            }
            return builder.toString();
        }

        private static Map<String, String> getBaseHttpHeaders() {
            HashMap<String, String> baseHeaders = new HashMap<String, String>();
            baseHeaders.put("Date", new DateTimeRfc1123(OffsetDateTime.now(ZoneOffset.UTC)).toString());
            baseHeaders.put("Connection", "keep-alive");
            baseHeaders.put("X-Processed-Time", String.valueOf(Math.random() * 10.0));
            baseHeaders.put("Access-Control-Allow-Credentials", "true");
            baseHeaders.put("Content-Type", "application/json");
            return baseHeaders;
        }

        private static HttpHeaders toWireMockHeaders(Map<String, String> rawHeaders) {
            return new HttpHeaders((Iterable)rawHeaders.entrySet().stream().map(kvp -> new HttpHeader((String)kvp.getKey(), new String[]{(String)kvp.getValue()})).collect(Collectors.toList()));
        }

        public String getName() {
            return "rest-proxy-transformer";
        }
    }
}

