/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.FakeTestClass;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.opentest4j.TestAbortedException;

public class TestContextManagerTests {
    @ParameterizedTest(name="[{index}] {displayName}")
    @EnumSource(value=TestMode.class)
    public void testWithoutDoNotRecord(TestMode testMode) {
        TestContextManager testContextManager = new TestContextManager(FakeTestClass.METHOD_WITHOUT_DONOTRECORD, testMode);
        Assertions.assertFalse((boolean)testContextManager.doNotRecordTest());
        Assertions.assertTrue((boolean)testContextManager.didTestRun());
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @EnumSource(value=TestMode.class)
    public void testWithDoNotRecordRunInPlayback(TestMode testMode) {
        TestContextManager testContextManager = new TestContextManager(FakeTestClass.DONOTRECORD_FALSE_SKIPINPLAYBACK, testMode);
        Assertions.assertTrue((boolean)testContextManager.doNotRecordTest());
        Assertions.assertTrue((boolean)testContextManager.didTestRun());
    }

    @Test
    public void testWithDoNotRecordSkipInPlayback() {
        Method testMethod = FakeTestClass.DONOTRECORD_SKIPINPLAYBACK;
        Assertions.assertThrows(TestAbortedException.class, () -> new TestContextManager(testMethod, TestMode.PLAYBACK));
        TestContextManager testContextManager = new TestContextManager(testMethod, TestMode.LIVE);
        Assertions.assertTrue((boolean)testContextManager.doNotRecordTest());
        Assertions.assertTrue((boolean)testContextManager.didTestRun());
        testContextManager = new TestContextManager(testMethod, TestMode.RECORD);
        Assertions.assertTrue((boolean)testContextManager.doNotRecordTest());
        Assertions.assertTrue((boolean)testContextManager.didTestRun());
    }
}

