/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation;

import com.azure.core.http.HttpClient;
import com.azure.core.test.TestBase;
import com.azure.core.test.TestMode;
import com.azure.core.test.implementation.AzureMethodSourceArgumentsProvider;
import com.azure.core.test.implementation.AzureTestingServiceVersion;
import com.azure.core.test.implementation.FullyQualifiedSourceSupplierTestHelper;
import com.azure.core.test.implementation.ServiceVersionWithoutGetLatest;
import com.azure.core.util.ServiceVersion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.platform.commons.PreconditionViolationException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import reactor.core.publisher.Mono;

public class AzureMethodSourceArgumentsProviderTests {
    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"getServiceVersionsSupplier"})
    public void getServiceVersionsTest(String minimumServiceVersion, String maximumServiceVersion, TestMode testMode, boolean testAllServiceVersions, List<? extends ServiceVersion> expectedServiceVersions) {
        List actualServiceVersions = AzureMethodSourceArgumentsProvider.getServiceVersions((String)minimumServiceVersion, (String)maximumServiceVersion, AzureTestingServiceVersion.class, (TestMode)testMode, (boolean)testAllServiceVersions);
        Assertions.assertEquals((int)expectedServiceVersions.size(), (int)actualServiceVersions.size());
        for (int i = 0; i < expectedServiceVersions.size(); ++i) {
            Assertions.assertEquals((Object)expectedServiceVersions.get(i), actualServiceVersions.get(i));
        }
    }

    private static Stream<Arguments> getServiceVersionsSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"", "", TestMode.PLAYBACK, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "", TestMode.PLAYBACK, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "", TestMode.PLAYBACK, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "", TestMode.PLAYBACK, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "ga", TestMode.PLAYBACK, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "ga", TestMode.PLAYBACK, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "beta", TestMode.PLAYBACK, false, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"", "beta", TestMode.PLAYBACK, true, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"beta", "ga", TestMode.PLAYBACK, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "ga", TestMode.PLAYBACK, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "beta", TestMode.PLAYBACK, false, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"beta", "beta", TestMode.PLAYBACK, true, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"", "", TestMode.RECORD, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "", TestMode.RECORD, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "", TestMode.RECORD, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "", TestMode.RECORD, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "ga", TestMode.RECORD, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "ga", TestMode.RECORD, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "beta", TestMode.RECORD, false, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"", "beta", TestMode.RECORD, true, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"beta", "ga", TestMode.RECORD, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "ga", TestMode.RECORD, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "beta", TestMode.RECORD, false, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"beta", "beta", TestMode.RECORD, true, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"", "", TestMode.LIVE, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "", TestMode.LIVE, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "ga", TestMode.LIVE, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "beta", TestMode.LIVE, false, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"beta", "ga", TestMode.LIVE, false, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "beta", TestMode.LIVE, false, Collections.singletonList(AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"", "", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.ALPHA, AzureTestingServiceVersion.BETA, AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"alpha", "", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.ALPHA, AzureTestingServiceVersion.BETA, AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.BETA, AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"ga", "", TestMode.LIVE, true, Collections.singletonList(AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"", "alpha", TestMode.LIVE, true, Collections.singletonList(AzureTestingServiceVersion.ALPHA)}), Arguments.of((Object[])new Object[]{"", "beta", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.ALPHA, AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"", "ga", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.ALPHA, AzureTestingServiceVersion.BETA, AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"alpha", "ga", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.ALPHA, AzureTestingServiceVersion.BETA, AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"beta", "ga", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.BETA, AzureTestingServiceVersion.GA)}), Arguments.of((Object[])new Object[]{"alpha", "beta", TestMode.LIVE, true, Arrays.asList(AzureTestingServiceVersion.ALPHA, AzureTestingServiceVersion.BETA)}), Arguments.of((Object[])new Object[]{"beta", "beta", TestMode.LIVE, true, Collections.singletonList(AzureTestingServiceVersion.BETA)}));
    }

    @Test
    public void nonEnumServiceVersionTypeThrows() {
        Assertions.assertThrows(IllegalStateException.class, () -> AzureMethodSourceArgumentsProvider.getServiceVersions((String)"", (String)"", ServiceVersion.class, (TestMode)TestMode.LIVE, (boolean)false));
    }

    @Test
    public void serviceVersionTypeWithoutGetLatestThrows() {
        Assertions.assertThrows(IllegalStateException.class, () -> AzureMethodSourceArgumentsProvider.getServiceVersions((String)"", (String)"", ServiceVersionWithoutGetLatest.class, (TestMode)TestMode.LIVE, (boolean)false));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"invokeSupplierMethodSupplier"})
    public void invokeSupplierMethodTests(ExtensionContext context, String sourceSupplier, Stream<Arguments> expected) throws Exception {
        Object actual = AzureMethodSourceArgumentsProvider.invokeSupplierMethod((ExtensionContext)context, (String)sourceSupplier);
        Assertions.assertTrue((boolean)(actual instanceof Stream));
        Iterator actualIterator = ((Stream)actual).iterator();
        Iterator expectedIterator = expected.iterator();
        while (actualIterator.hasNext()) {
            Assertions.assertTrue((boolean)expectedIterator.hasNext());
            Object actualNext = actualIterator.next();
            Arguments expectedNext = (Arguments)expectedIterator.next();
            Assertions.assertTrue((boolean)(actualNext instanceof Arguments));
            Assertions.assertArrayEquals((Object[])expectedNext.get(), (Object[])((Arguments)actualNext).get());
        }
        Assertions.assertFalse((boolean)expectedIterator.hasNext());
    }

    private static Stream<Arguments> invokeSupplierMethodSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, "com.azure.core.test.implementation.AzureMethodSourceArgumentsProviderTests#staticAndValidReturnType", AzureMethodSourceArgumentsProviderTests.staticAndValidReturnType()}), Arguments.of((Object[])new Object[]{null, "com.azure.core.test.implementation.FullyQualifiedSourceSupplierTestHelper#staticAndValidReturnType", FullyQualifiedSourceSupplierTestHelper.staticAndValidReturnType()}), Arguments.of((Object[])new Object[]{AzureMethodSourceArgumentsProviderTests.getMockExtensionContext(AzureMethodSourceArgumentsProviderTests.class), "staticAndValidReturnType", AzureMethodSourceArgumentsProviderTests.staticAndValidReturnType()}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"invalidFullyQualifiedSourceSupplierThrowsSupplier"})
    public void invalidFullyQualifiedSourceSupplierThrows(String sourceSupplier, Class<? extends Throwable> expectedException) {
        Assertions.assertThrows(expectedException, () -> AzureMethodSourceArgumentsProvider.invokeSupplierMethod(null, (String)sourceSupplier));
    }

    private static Stream<Arguments> invalidFullyQualifiedSourceSupplierThrowsSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"#", PreconditionViolationException.class}), Arguments.of((Object[])new Object[]{"com.azure.core.test.TestBase#", PreconditionViolationException.class}), Arguments.of((Object[])new Object[]{"#supplierMethod", PreconditionViolationException.class}), Arguments.of((Object[])new Object[]{"supplierClass#supplierMethod", ClassNotFoundException.class}), Arguments.of((Object[])new Object[]{"com.azure.core.test.TestBase#notARealMethod", IllegalArgumentException.class}), Arguments.of((Object[])new Object[]{"com.azure.core.test.implementation.FullyQualifiedSourceSupplierTestHelper#staticAndValidReturnTypeButHasParameters", IllegalArgumentException.class}), Arguments.of((Object[])new Object[]{"com.azure.core.test.implementation.FullyQualifiedSourceSupplierTestHelper#staticAndValidReturnTypeButHasParameters", IllegalArgumentException.class}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"validateSourceSupplierTestSupplier"})
    public void validateSourceSupplierTest(Method validSourceSupplier) {
        Assertions.assertDoesNotThrow(() -> AzureMethodSourceArgumentsProvider.validateSourceSupplier((Method)validSourceSupplier));
    }

    private static Stream<Arguments> validateSourceSupplierTestSupplier() throws NoSuchMethodException {
        Class<AzureMethodSourceArgumentsProviderTests> thisClass = AzureMethodSourceArgumentsProviderTests.class;
        Class<FullyQualifiedSourceSupplierTestHelper> anotherClass = FullyQualifiedSourceSupplierTestHelper.class;
        return Stream.of(Arguments.of((Object[])new Object[]{thisClass.getMethod("staticAndValidReturnType", new Class[0])}), Arguments.of((Object[])new Object[]{anotherClass.getMethod("staticAndValidReturnType", new Class[0])}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"invalidSourceSupplerSupplier"})
    public void invalidSourceSupplier(Method invalidSourceSupplier) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AzureMethodSourceArgumentsProvider.validateSourceSupplier((Method)invalidSourceSupplier));
    }

    private static Stream<Arguments> invalidSourceSupplerSupplier() throws NoSuchMethodException {
        Class<AzureMethodSourceArgumentsProviderTests> thisClass = AzureMethodSourceArgumentsProviderTests.class;
        Class<FullyQualifiedSourceSupplierTestHelper> anotherClass = FullyQualifiedSourceSupplierTestHelper.class;
        return Stream.of(Arguments.of((Object[])new Object[]{thisClass.getMethod("nonStaticAndInvalidReturnTypeMethod", new Class[0])}), Arguments.of((Object[])new Object[]{thisClass.getMethod("anotherNonStaticAndInvalidReturnTypeMethod", new Class[0])}), Arguments.of((Object[])new Object[]{thisClass.getMethod("nonStaticMethod", new Class[0])}), Arguments.of((Object[])new Object[]{thisClass.getMethod("staticButInvalidReturnTypeMethod", new Class[0])}), Arguments.of((Object[])new Object[]{thisClass.getMethod("anotherStaticButInvalidReturnTypeMethod", new Class[0])}), Arguments.of((Object[])new Object[]{anotherClass.getMethod("nonStaticAndInvalidReturnTypeMethod", new Class[0])}), Arguments.of((Object[])new Object[]{anotherClass.getMethod("anotherNonStaticAndInvalidReturnTypeMethod", new Class[0])}), Arguments.of((Object[])new Object[]{anotherClass.getMethod("nonStaticMethod", new Class[0])}), Arguments.of((Object[])new Object[]{anotherClass.getMethod("staticButInvalidReturnTypeMethod", new Class[0])}), Arguments.of((Object[])new Object[]{anotherClass.getMethod("anotherStaticButInvalidReturnTypeMethod", new Class[0])}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"invalidRelativelyQualifiedSourceSupplierThrows"})
    public void invalidRelativelyQualifiedSourceSupplierThrows(ExtensionContext extensionContext, String sourceSupplier, Class<? extends Throwable> expectedException) {
        Assertions.assertThrows(expectedException, () -> AzureMethodSourceArgumentsProvider.invokeSupplierMethod((ExtensionContext)extensionContext, (String)sourceSupplier));
    }

    private static Stream<Arguments> invalidRelativelyQualifiedSourceSupplierThrows() {
        return Stream.of(Arguments.of((Object[])new Object[]{AzureMethodSourceArgumentsProviderTests.getMockExtensionContext(null), "notARealMethod", PreconditionViolationException.class}), Arguments.of((Object[])new Object[]{AzureMethodSourceArgumentsProviderTests.getMockExtensionContext(TestBase.class), "notARealMethod", IllegalArgumentException.class}), Arguments.of((Object[])new Object[]{AzureMethodSourceArgumentsProviderTests.getMockExtensionContext(TestBase.class), "getTestMode", IllegalArgumentException.class}));
    }

    private static ExtensionContext getMockExtensionContext(Class<?> testClass) {
        ExtensionContext mockExtensionContext = (ExtensionContext)Mockito.mock(ExtensionContext.class, (Answer)Mockito.CALLS_REAL_METHODS);
        if (testClass == null) {
            Mockito.when((Object)mockExtensionContext.getTestClass()).thenReturn(Optional.empty());
        } else {
            Mockito.when((Object)mockExtensionContext.getTestClass()).thenReturn(Optional.of(testClass));
        }
        return mockExtensionContext;
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"convertToArgumentsTestSupplier"})
    public void convertToArgumentsTest(Object value, Arguments expected) {
        Arguments actual = AzureMethodSourceArgumentsProvider.convertToArguments((Object)value);
        Assertions.assertArrayEquals((Object[])expected.get(), (Object[])actual.get());
    }

    private static Stream<Arguments> convertToArgumentsTestSupplier() {
        Arguments emptyArgumentsMock = (Arguments)Mockito.mock(Arguments.class);
        Mockito.when((Object)emptyArgumentsMock.get()).thenReturn(null);
        Arguments nonEmptyArguments = Arguments.of((Object[])new Object[]{"1", 1, null, new byte[0]});
        return Stream.of(Arguments.of((Object[])new Object[]{emptyArgumentsMock, emptyArgumentsMock}), Arguments.of((Object[])new Object[]{nonEmptyArguments, nonEmptyArguments}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"invalidArgumentTypesSupplier"})
    public void invalidArgumentTypes(Object argument) {
        Assertions.assertThrows(IllegalStateException.class, () -> AzureMethodSourceArgumentsProvider.convertToArguments((Object)argument));
    }

    private static Stream<Arguments> invalidArgumentTypesSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{1}), Arguments.of((Object[])new Object[]{"1"}), Arguments.of((Object[])new Object[]{1.0}), Arguments.of((Object[])new Object[]{true}), Arguments.of((Object[])new Object[]{new Object()}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"createHttpServiceVersionPermutationsTestSupplier"})
    public void createHttpServiceVersionPermutationsTest(List<HttpClient> httpClients, List<ServiceVersion> serviceVersions, List<Arguments> expected) {
        List actual = AzureMethodSourceArgumentsProvider.createHttpServiceVersionPermutations(httpClients, serviceVersions);
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertArrayEquals((Object[])expected.get(i).get(), (Object[])((Arguments)actual.get(i)).get());
        }
    }

    private static Stream<Arguments> createHttpServiceVersionPermutationsTestSupplier() {
        HttpClient noOpHttpClient = request -> Mono.empty();
        HttpClient alwaysErrorHttpClient = request -> Mono.error((Throwable)new RuntimeException("Always errors"));
        AzureTestingServiceVersion alpha = AzureTestingServiceVersion.ALPHA;
        AzureTestingServiceVersion beta = AzureTestingServiceVersion.BETA;
        AzureTestingServiceVersion ga = AzureTestingServiceVersion.GA;
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.singletonList(noOpHttpClient), Collections.singletonList(alpha), Collections.singletonList(Arguments.arguments((Object[])new Object[]{noOpHttpClient, alpha}))}), Arguments.of((Object[])new Object[]{Arrays.asList(noOpHttpClient, alwaysErrorHttpClient), Collections.singletonList(alpha), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha}))}), Arguments.of((Object[])new Object[]{Collections.singletonList(noOpHttpClient), Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga}))}), Arguments.of((Object[])new Object[]{Arrays.asList(noOpHttpClient, alwaysErrorHttpClient), Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, beta}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, ga}))}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"createNonHttpPermutationsTestSupplier"})
    public void createNonHttpPermutationsTest(List<ServiceVersion> serviceVersions, List<Arguments> parameterizedTestingValues, List<Arguments> expected) {
        List actual = AzureMethodSourceArgumentsProvider.createNonHttpPermutations(serviceVersions, parameterizedTestingValues);
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertArrayEquals((Object[])expected.get(i).get(), (Object[])((Arguments)actual.get(i)).get());
        }
    }

    private static Stream<Arguments> createNonHttpPermutationsTestSupplier() {
        AzureTestingServiceVersion alpha = AzureTestingServiceVersion.ALPHA;
        AzureTestingServiceVersion beta = AzureTestingServiceVersion.BETA;
        AzureTestingServiceVersion ga = AzureTestingServiceVersion.GA;
        Arguments simpleArguments = Arguments.of((Object[])new Object[]{1, 2});
        Arguments complexArguments = Arguments.of((Object[])new Object[]{1, "1", true});
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.singletonList(alpha), Collections.singletonList(simpleArguments), Collections.singletonList(Arguments.of((Object[])new Object[]{alpha, 1, 2}))}), Arguments.of((Object[])new Object[]{Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Collections.singletonList(simpleArguments), Arrays.asList(Arguments.of((Object[])new Object[]{alpha, 1, 2}), Arguments.of((Object[])new Object[]{beta, 1, 2}), Arguments.of((Object[])new Object[]{ga, 1, 2}))}), Arguments.of((Object[])new Object[]{Collections.singletonList(alpha), Arrays.asList(simpleArguments, complexArguments), Arrays.asList(Arguments.of((Object[])new Object[]{alpha, 1, 2}), Arguments.of((Object[])new Object[]{alpha, 1, "1", true}))}), Arguments.of((Object[])new Object[]{Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Arrays.asList(simpleArguments, complexArguments), Arrays.asList(Arguments.of((Object[])new Object[]{alpha, 1, 2}), Arguments.of((Object[])new Object[]{alpha, 1, "1", true}), Arguments.of((Object[])new Object[]{beta, 1, 2}), Arguments.of((Object[])new Object[]{beta, 1, "1", true}), Arguments.of((Object[])new Object[]{ga, 1, 2}), Arguments.of((Object[])new Object[]{ga, 1, "1", true}))}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"createFullPermutationsTestSupplier"})
    public void createFullPermutationsTest(List<HttpClient> httpClients, List<ServiceVersion> serviceVersions, List<Arguments> parameterizedTestingValues, List<Arguments> expected) {
        List actual = AzureMethodSourceArgumentsProvider.createFullPermutations(httpClients, serviceVersions, parameterizedTestingValues);
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertArrayEquals((Object[])expected.get(i).get(), (Object[])((Arguments)actual.get(i)).get());
        }
    }

    private static Stream<Arguments> createFullPermutationsTestSupplier() {
        HttpClient noOpHttpClient = request -> Mono.empty();
        HttpClient alwaysErrorHttpClient = request -> Mono.error((Throwable)new RuntimeException("Always errors"));
        AzureTestingServiceVersion alpha = AzureTestingServiceVersion.ALPHA;
        AzureTestingServiceVersion beta = AzureTestingServiceVersion.BETA;
        AzureTestingServiceVersion ga = AzureTestingServiceVersion.GA;
        Arguments simpleArguments = Arguments.of((Object[])new Object[]{1, 2});
        Arguments complexArguments = Arguments.of((Object[])new Object[]{1, "1", true});
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.singletonList(noOpHttpClient), Collections.singletonList(alpha), Collections.singletonList(simpleArguments), Collections.singletonList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}))}), Arguments.of((Object[])new Object[]{Arrays.asList(noOpHttpClient, alwaysErrorHttpClient), Collections.singletonList(alpha), Collections.singletonList(simpleArguments), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha, 1, 2}))}), Arguments.of((Object[])new Object[]{Arrays.asList(noOpHttpClient, alwaysErrorHttpClient), Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Collections.singletonList(simpleArguments), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, beta, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, ga, 1, 2}))}), Arguments.of((Object[])new Object[]{Arrays.asList(noOpHttpClient, alwaysErrorHttpClient), Collections.singletonList(alpha), Arrays.asList(simpleArguments, complexArguments), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, "1", true}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha, 1, "1", true}))}), Arguments.of((Object[])new Object[]{Collections.singletonList(noOpHttpClient), Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Collections.singletonList(simpleArguments), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga, 1, 2}))}), Arguments.of((Object[])new Object[]{Collections.singletonList(noOpHttpClient), Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Arrays.asList(simpleArguments, complexArguments), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, "1", true}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta, 1, "1", true}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga, 1, "1", true}))}), Arguments.of((Object[])new Object[]{Collections.singletonList(noOpHttpClient), Collections.singletonList(alpha), Arrays.asList(simpleArguments, complexArguments), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, "1", true}))}), Arguments.of((Object[])new Object[]{Arrays.asList(noOpHttpClient, alwaysErrorHttpClient), Arrays.asList(new ServiceVersion[]{alpha, beta, ga}), Arrays.asList(simpleArguments, complexArguments), Arrays.asList(Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, alpha, 1, "1", true}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, beta, 1, "1", true}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga, 1, 2}), Arguments.of((Object[])new Object[]{noOpHttpClient, ga, 1, "1", true}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, alpha, 1, "1", true}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, beta, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, beta, 1, "1", true}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, ga, 1, 2}), Arguments.of((Object[])new Object[]{alwaysErrorHttpClient, ga, 1, "1", true}))}));
    }

    public int nonStaticAndInvalidReturnTypeMethod() {
        return 1;
    }

    public Stream<Integer> anotherNonStaticAndInvalidReturnTypeMethod() {
        return Stream.of(Integer.valueOf(1));
    }

    public Stream<Arguments> nonStaticMethod() {
        return Stream.of(Arguments.of((Object[])new Object[]{1}));
    }

    public static int staticButInvalidReturnTypeMethod() {
        return 1;
    }

    public static Stream<Integer> anotherStaticButInvalidReturnTypeMethod() {
        return Stream.of(Integer.valueOf(1));
    }

    public static Stream<Arguments> staticAndValidReturnTypeButHasParameters(Object dummyParam) {
        return Stream.of(Arguments.of((Object[])new Object[]{dummyParam}));
    }

    public static Stream<Arguments> staticAndValidReturnType() {
        return Stream.of(Arguments.of((Object[])new Object[]{1}));
    }

    public static Stream<Arguments> simpleArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{1, 2}));
    }

    public static Stream<Arguments> complexArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{1, "1", true}));
    }

    public static Stream<Arguments> multipleArgumentElements() {
        return Stream.concat(AzureMethodSourceArgumentsProviderTests.simpleArguments(), AzureMethodSourceArgumentsProviderTests.complexArguments());
    }
}

