/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderCollection;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.implementation.UnixTime;
import com.azure.core.test.http.MockHttpClient;
import com.azure.core.test.http.MockHttpResponse;
import com.azure.core.test.http.NoOpHttpClient;
import com.azure.core.test.implementation.RestProxyTests;
import com.azure.core.test.implementation.entities.HttpBinJSON;
import com.azure.core.util.Base64Url;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.IterableStream;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class RestProxyWithMockTests
extends RestProxyTests {
    private static final HttpClient HEADER_COLLECTION_HTTP_CLIENT = new NoOpHttpClient(){

        public Mono<HttpResponse> send(HttpRequest request) {
            HttpHeaders headers = new HttpHeaders().set("name", "Phillip").set("header-collection-prefix-one", "1").set("header-collection-prefix-two", "2").set("header-collection-prefix-three", "3");
            MockHttpResponse response = new MockHttpResponse(request, 200, headers);
            return Mono.just((Object)response);
        }
    };

    protected int getWireMockPort() {
        return 80;
    }

    protected HttpClient createHttpClient() {
        return new MockHttpClient();
    }

    @Test
    public void service1GetBase64UrlBytes10() {
        byte[] bytes = ((Service1)this.createService(Service1.class)).getBase64UrlBytes10();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)10, (int)bytes.length);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((byte)((byte)i), (byte)bytes[i]);
        }
    }

    @Test
    public void service1GetBase64UrlListOfBytes() {
        List<byte[]> bytesList = ((Service1)this.createService(Service1.class)).getBase64UrlListOfBytes();
        Assertions.assertNotNull(bytesList);
        Assertions.assertEquals((int)3, (int)bytesList.size());
        for (int i = 0; i < bytesList.size(); ++i) {
            byte[] bytes = bytesList.get(i);
            Assertions.assertNotNull((Object)bytes);
            Assertions.assertEquals((int)((i + 1) * 10), (int)bytes.length);
            for (int j = 0; j < bytes.length; ++j) {
                Assertions.assertEquals((byte)((byte)j), (byte)bytes[j]);
            }
        }
    }

    @Test
    public void service1GetBase64UrlListOfListOfBytes() {
        List<List<byte[]>> bytesList = ((Service1)this.createService(Service1.class)).getBase64UrlListOfListOfBytes();
        Assertions.assertNotNull(bytesList);
        Assertions.assertEquals((int)2, (int)bytesList.size());
        for (int i = 0; i < bytesList.size(); ++i) {
            List<byte[]> innerList = bytesList.get(i);
            Assertions.assertEquals((int)((i + 1) * 2), (int)innerList.size());
            for (int j = 0; j < innerList.size(); ++j) {
                byte[] bytes = innerList.get(j);
                Assertions.assertNotNull((Object)bytes);
                Assertions.assertEquals((int)((j + 1) * 5), (int)bytes.length);
                for (int k = 0; k < bytes.length; ++k) {
                    Assertions.assertEquals((int)k, (int)bytes[k]);
                }
            }
        }
    }

    @Test
    public void service1GetBase64UrlMapOfBytes() {
        Map<String, byte[]> bytesMap = ((Service1)this.createService(Service1.class)).getBase64UrlMapOfBytes();
        Assertions.assertNotNull(bytesMap);
        Assertions.assertEquals((int)2, (int)bytesMap.size());
        for (int i = 0; i < bytesMap.size(); ++i) {
            byte[] bytes = bytesMap.get(Integer.toString(i));
            int expectedArrayLength = (i + 1) * 10;
            Assertions.assertEquals((int)expectedArrayLength, (int)bytes.length);
            for (int j = 0; j < expectedArrayLength; ++j) {
                Assertions.assertEquals((byte)((byte)j), (byte)bytes[j]);
            }
        }
    }

    @Test
    public void service1GetDateTimeRfc1123() {
        OffsetDateTime dateTime = ((Service1)this.createService(Service1.class)).getDateTimeRfc1123();
        Assertions.assertNotNull((Object)dateTime);
        Assertions.assertEquals((Object)OffsetDateTime.ofInstant(Instant.ofEpochMilli(0L), ZoneOffset.UTC), (Object)dateTime);
    }

    @Test
    public void service1GetDateTimeUnix() {
        OffsetDateTime dateTime = ((Service1)this.createService(Service1.class)).getDateTimeUnix();
        Assertions.assertNotNull((Object)dateTime);
        Assertions.assertEquals((Object)OffsetDateTime.ofInstant(Instant.ofEpochMilli(0L), ZoneOffset.UTC), (Object)dateTime);
    }

    @Test
    public void serviceErrorWithResponseContentType() {
        ServiceErrorWithCharsetService service = (ServiceErrorWithCharsetService)RestProxy.create(ServiceErrorWithCharsetService.class, (HttpPipeline)new HttpPipelineBuilder().httpClient((HttpClient)new SimpleMockHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                HttpHeaders headers = new HttpHeaders().set("Content-Type", "application/json");
                MockHttpResponse response = new MockHttpResponse(request, 200, headers, "{ \"error\": \"Something went wrong, but at least this JSON is valid.\"}".getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)response);
            }
        }).build());
        try {
            service.get();
            Assertions.fail();
        }
        catch (RuntimeException ex) {
            Assertions.assertEquals((Object)ex.getMessage(), (Object)"Status code 200, \"{ \"error\": \"Something went wrong, but at least this JSON is valid.\"}\"");
        }
    }

    @Test
    public void serviceErrorWithResponseContentTypeBadJSON() {
        ServiceErrorWithCharsetService service = (ServiceErrorWithCharsetService)RestProxy.create(ServiceErrorWithCharsetService.class, (HttpPipeline)new HttpPipelineBuilder().httpClient((HttpClient)new SimpleMockHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                HttpHeaders headers = new HttpHeaders().set("Content-Type", "application/json");
                MockHttpResponse response = new MockHttpResponse(request, 200, headers, "BAD JSON".getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)response);
            }
        }).build());
        try {
            service.get();
            Assertions.fail();
        }
        catch (HttpResponseException ex) {
            RestProxyWithMockTests.assertContains(ex.getMessage(), "Status code 200");
            RestProxyWithMockTests.assertContains(ex.getMessage(), "\"BAD JSON\"");
        }
    }

    @Test
    public void serviceErrorWithResponseContentTypeCharset() {
        ServiceErrorWithCharsetService service = (ServiceErrorWithCharsetService)RestProxy.create(ServiceErrorWithCharsetService.class, (HttpPipeline)new HttpPipelineBuilder().httpClient((HttpClient)new SimpleMockHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                HttpHeaders headers = new HttpHeaders().set("Content-Type", "application/json; charset=UTF-8");
                MockHttpResponse response = new MockHttpResponse(request, 200, headers, "{ \"error\": \"Something went wrong, but at least this JSON is valid.\"}".getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)response);
            }
        }).build());
        try {
            service.get();
            Assertions.fail();
        }
        catch (RuntimeException ex) {
            Assertions.assertEquals((Object)ex.getMessage(), (Object)"Status code 200, \"{ \"error\": \"Something went wrong, but at least this JSON is valid.\"}\"");
        }
    }

    @Test
    public void serviceErrorWithResponseContentTypeCharsetBadJSON() {
        ServiceErrorWithCharsetService service = (ServiceErrorWithCharsetService)RestProxy.create(ServiceErrorWithCharsetService.class, (HttpPipeline)new HttpPipelineBuilder().httpClient((HttpClient)new SimpleMockHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                HttpHeaders headers = new HttpHeaders().set("Content-Type", "application/json; charset=UTF-8");
                MockHttpResponse response = new MockHttpResponse(request, 200, headers, "BAD JSON".getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)response);
            }
        }).build());
        try {
            service.get();
            Assertions.fail();
        }
        catch (HttpResponseException ex) {
            RestProxyWithMockTests.assertContains(ex.getMessage(), "Status code 200");
            RestProxyWithMockTests.assertContains(ex.getMessage(), "\"BAD JSON\"");
        }
    }

    private ServiceHeaderCollections createHeaderCollectionsService() {
        return (ServiceHeaderCollections)this.createService(ServiceHeaderCollections.class, HEADER_COLLECTION_HTTP_CLIENT);
    }

    private static void assertHeaderCollectionsRawHeaders(Response<Void> response) {
        HttpHeaders responseRawHeaders = response.getHeaders();
        Assertions.assertEquals((Object)"Phillip", (Object)responseRawHeaders.getValue("name"));
        Assertions.assertEquals((Object)"1", (Object)responseRawHeaders.getValue("header-collection-prefix-one"));
        Assertions.assertEquals((Object)"2", (Object)responseRawHeaders.getValue("header-collection-prefix-two"));
        Assertions.assertEquals((Object)"3", (Object)responseRawHeaders.getValue("header-collection-prefix-three"));
        Assertions.assertEquals((int)4, (int)responseRawHeaders.getSize());
    }

    private static void assertHeaderCollections(Map<String, String> headerCollections) {
        HashMap<String, String> expectedHeaderCollections = new HashMap<String, String>();
        expectedHeaderCollections.put("one", "1");
        expectedHeaderCollections.put("two", "2");
        expectedHeaderCollections.put("three", "3");
        for (String key : headerCollections.keySet()) {
            Assertions.assertEquals(expectedHeaderCollections.get(key), (Object)headerCollections.get(key));
        }
        Assertions.assertEquals((int)expectedHeaderCollections.size(), (int)headerCollections.size());
    }

    @Test
    public void serviceHeaderCollectionPublicFields() {
        ResponseBase<HeaderCollectionTypePublicFields, Void> response = this.createHeaderCollectionsService().publicFields();
        Assertions.assertNotNull(response);
        RestProxyWithMockTests.assertHeaderCollectionsRawHeaders(response);
        HeaderCollectionTypePublicFields responseHeaders = (HeaderCollectionTypePublicFields)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)responseHeaders);
        Assertions.assertEquals((Object)"Phillip", (Object)responseHeaders.name());
        RestProxyWithMockTests.assertHeaderCollections(responseHeaders.headerCollection());
    }

    @Test
    public void serviceHeaderCollectionProtectedFields() {
        ResponseBase<HeaderCollectionTypeProtectedFields, Void> response = this.createHeaderCollectionsService().protectedFields();
        Assertions.assertNotNull(response);
        RestProxyWithMockTests.assertHeaderCollectionsRawHeaders(response);
        HeaderCollectionTypeProtectedFields responseHeaders = (HeaderCollectionTypeProtectedFields)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)responseHeaders);
        Assertions.assertEquals((Object)"Phillip", (Object)responseHeaders.name);
        RestProxyWithMockTests.assertHeaderCollections(responseHeaders.headerCollection);
    }

    @Test
    public void serviceHeaderCollectionPrivateFields() {
        ResponseBase<HeaderCollectionTypePrivateFields, Void> response = this.createHeaderCollectionsService().privateFields();
        Assertions.assertNotNull(response);
        RestProxyWithMockTests.assertHeaderCollectionsRawHeaders(response);
        HeaderCollectionTypePrivateFields responseHeaders = (HeaderCollectionTypePrivateFields)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)responseHeaders);
        Assertions.assertEquals((Object)"Phillip", (Object)responseHeaders.name);
        RestProxyWithMockTests.assertHeaderCollections(responseHeaders.headerCollection);
    }

    @Test
    public void serviceHeaderCollectionPackagePrivateFields() {
        ResponseBase<HeaderCollectionTypePackagePrivateFields, Void> response = this.createHeaderCollectionsService().packagePrivateFields();
        Assertions.assertNotNull(response);
        RestProxyWithMockTests.assertHeaderCollectionsRawHeaders(response);
        HeaderCollectionTypePackagePrivateFields responseHeaders = (HeaderCollectionTypePackagePrivateFields)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)responseHeaders);
        Assertions.assertEquals((Object)"Phillip", (Object)responseHeaders.name);
        RestProxyWithMockTests.assertHeaderCollections(responseHeaders.headerCollection);
    }

    private static void assertContains(String value, String expectedSubstring) {
        Assertions.assertTrue((boolean)value.contains(expectedSubstring), (String)("Expected \"" + value + "\" to contain \"" + expectedSubstring + "\"."));
    }

    @Test
    public void service2getPage() {
        ArrayList<KeyValue> array = new ArrayList<KeyValue>();
        KeyValue key1 = new KeyValue(1, "Foo");
        KeyValue key2 = new KeyValue(2, "Bar");
        KeyValue key3 = new KeyValue(10, "Baz");
        array.add(key1);
        array.add(key2);
        array.add(key3);
        KeyValuePage page = new KeyValuePage(array, "SomeNextLink");
        PagedResponse<KeyValue> response = ((Service2)this.createService(Service2.class)).getPage(page);
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)array.size(), (int)response.getValue().size());
    }

    @Test
    public void service2getPageAsync() {
        ArrayList<KeyValue> array = new ArrayList<KeyValue>();
        KeyValue key1 = new KeyValue(1, "Foo");
        KeyValue key2 = new KeyValue(2, "Bar");
        KeyValue key3 = new KeyValue(10, "Baz");
        array.add(key1);
        array.add(key2);
        array.add(key3);
        ConformingPage<KeyValue> page = new ConformingPage<KeyValue>(array, "MyNextLink");
        StepVerifier.create(((Service2)this.createService(Service2.class)).getPageAsync(page)).assertNext(r -> {
            Assertions.assertEquals((Object)page.continuationToken, (Object)r.getContinuationToken());
            Assertions.assertEquals((int)r.getValue().size(), (int)3);
            for (KeyValue keyValue : r.getValue()) {
                Assertions.assertTrue((boolean)array.removeIf(kv -> kv.key == keyValue.key && kv.value().equals(keyValue.value())));
            }
            Assertions.assertTrue((boolean)array.isEmpty());
        }).verifyComplete();
    }

    @Test
    public void service2getPageSerializes() {
        ArrayList<KeyValue> array = new ArrayList<KeyValue>();
        KeyValue key1 = new KeyValue(1, "Foo");
        KeyValue key2 = new KeyValue(2, "Bar");
        KeyValue key3 = new KeyValue(10, "Baz");
        array.add(key1);
        array.add(key2);
        array.add(key3);
        NonConformingPage<KeyValue> page = new NonConformingPage<KeyValue>(array, "A next link!");
        StepVerifier.create(((Service2)this.createService(Service2.class)).getPageAsyncSerializes(page)).assertNext(response -> {
            Assertions.assertEquals((Object)page.getContinuationToken(), (Object)response.getContinuationToken());
            Assertions.assertEquals((int)0, (int)response.getValue().size());
        }).verifyComplete();
    }

    @Host(value="http://echo.org")
    @ServiceInterface(name="Service2")
    static interface Service2 {
        @Post(value="anything/json")
        @ExpectedResponses(value={200})
        @ReturnValueWireType(value=KeyValuePage.class)
        public PagedResponse<KeyValue> getPage(@BodyParam(value="application/json") Page<KeyValue> var1);

        @Post(value="anything/json")
        @ExpectedResponses(value={200})
        @ReturnValueWireType(value=Page.class)
        public Mono<PagedResponse<KeyValue>> getPageAsync(@BodyParam(value="application/json") Page<KeyValue> var1);

        @Post(value="anything/json")
        @ExpectedResponses(value={200})
        @ReturnValueWireType(value=Page.class)
        public Mono<PagedResponse<KeyValue>> getPageAsyncSerializes(@BodyParam(value="application/json") NonConformingPage<KeyValue> var1);
    }

    static class NonConformingPage<T> {
        private List<T> badItems;
        private String continuationToken;

        NonConformingPage(List<T> items, String continuationToken) {
            this.badItems = items;
            this.continuationToken = continuationToken;
        }

        @JsonGetter
        public List<T> badItems() {
            return this.badItems;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }
    }

    static class ConformingPage<T>
    implements Page<T> {
        private List<T> items;
        private String continuationToken;

        ConformingPage(List<T> items, String continuationToken) {
            this.items = items;
            this.continuationToken = continuationToken;
        }

        public IterableStream<T> getElements() {
            return IterableStream.of(this.items);
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }
    }

    static class KeyValuePage
    implements Page<KeyValue> {
        @JsonProperty
        private List<KeyValue> items;
        @JsonProperty(value="nextLink")
        private String continuationToken;

        KeyValuePage() {
        }

        KeyValuePage(List<KeyValue> items, String continuationToken) {
            this.items = items;
            this.continuationToken = continuationToken;
        }

        public IterableStream<KeyValue> getElements() {
            return new IterableStream(this.items);
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }
    }

    static class KeyValue {
        @JsonProperty(value="key")
        private int key;
        @JsonProperty(value="value")
        private String value;

        KeyValue() {
        }

        KeyValue(int key, String value) {
            this.key = key;
            this.value = value;
        }

        int key() {
            return this.key;
        }

        String value() {
            return this.value;
        }
    }

    private static abstract class SimpleMockHttpClient
    implements HttpClient {
        private SimpleMockHttpClient() {
        }

        public abstract Mono<HttpResponse> send(HttpRequest var1);
    }

    @Host(value="https://www.example.com")
    @ServiceInterface(name="ServiceHeaderCollections")
    static interface ServiceHeaderCollections {
        @Get(value="url/path")
        public ResponseBase<HeaderCollectionTypePublicFields, Void> publicFields();

        @Get(value="url/path")
        public ResponseBase<HeaderCollectionTypeProtectedFields, Void> protectedFields();

        @Get(value="url/path")
        public ResponseBase<HeaderCollectionTypePrivateFields, Void> privateFields();

        @Get(value="url/path")
        public ResponseBase<HeaderCollectionTypePackagePrivateFields, Void> packagePrivateFields();
    }

    private static class HeaderCollectionTypePackagePrivateFields {
        String name;
        @HeaderCollection(value="header-collection-prefix-")
        Map<String, String> headerCollection;

        private HeaderCollectionTypePackagePrivateFields() {
        }
    }

    private static class HeaderCollectionTypePrivateFields {
        private String name;
        @HeaderCollection(value="header-collection-prefix-")
        private Map<String, String> headerCollection;

        private HeaderCollectionTypePrivateFields() {
        }
    }

    private static class HeaderCollectionTypeProtectedFields {
        protected String name;
        @HeaderCollection(value="header-collection-prefix-")
        protected Map<String, String> headerCollection;

        private HeaderCollectionTypeProtectedFields() {
        }
    }

    private static class HeaderCollectionTypePublicFields {
        @JsonProperty
        private String name;
        @HeaderCollection(value="header-collection-prefix-")
        private Map<String, String> headerCollection;

        private HeaderCollectionTypePublicFields() {
        }

        public String name() {
            return this.name;
        }

        public void name(String name) {
            this.name = name;
        }

        public Map<String, String> headerCollection() {
            return this.headerCollection;
        }

        public void headerCollection(Map<String, String> headerCollection) {
            this.headerCollection = headerCollection;
        }
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="ServiceErrorWithCharsetService")
    static interface ServiceErrorWithCharsetService {
        @Get(value="/get")
        @ExpectedResponses(value={400})
        public HttpBinJSON get();
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service1")
    private static interface Service1 {
        @Get(value="Base64UrlBytes/10")
        @ReturnValueWireType(value=Base64Url.class)
        public byte[] getBase64UrlBytes10();

        @Get(value="Base64UrlListOfBytes")
        @ReturnValueWireType(value=Base64Url.class)
        public List<byte[]> getBase64UrlListOfBytes();

        @Get(value="Base64UrlListOfListOfBytes")
        @ReturnValueWireType(value=Base64Url.class)
        public List<List<byte[]>> getBase64UrlListOfListOfBytes();

        @Get(value="Base64UrlMapOfBytes")
        @ReturnValueWireType(value=Base64Url.class)
        public Map<String, byte[]> getBase64UrlMapOfBytes();

        @Get(value="DateTimeRfc1123")
        @ReturnValueWireType(value=DateTimeRfc1123.class)
        public OffsetDateTime getDateTimeRfc1123();

        @Get(value="UnixTime")
        @ReturnValueWireType(value=UnixTime.class)
        public OffsetDateTime getDateTimeUnix();
    }
}

