/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.test.FakeTestClass;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.utils.TestResourceNamer;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class TestResourceNamerTests {
    private static final String A_VARIABLE = "aVariable";
    private static final String RANDOM_NAME_PREFIX = "prefix";
    private static final int RANDOM_NAME_LENGTH = 12;
    private static final String CONFIG_VALUE = "value";

    @Test
    public void nullRecordedData() {
        Assertions.assertDoesNotThrow(() -> new TestResourceNamer(new TestContextManager(FakeTestClass.METHOD_WITHOUT_DONOTRECORD, TestMode.LIVE), null));
        Assertions.assertDoesNotThrow(() -> new TestResourceNamer(new TestContextManager(FakeTestClass.DONOTRECORD_FALSE_SKIPINPLAYBACK, TestMode.RECORD), null));
        Assertions.assertThrows(NullPointerException.class, () -> new TestResourceNamer(new TestContextManager(FakeTestClass.METHOD_WITHOUT_DONOTRECORD, TestMode.RECORD), null));
        Assertions.assertThrows(NullPointerException.class, () -> new TestResourceNamer(new TestContextManager(FakeTestClass.METHOD_WITHOUT_DONOTRECORD, TestMode.PLAYBACK), null));
    }

    @Test
    public void recordedDataIsNotAllowedToReadRecordedValues() {
        TestResourceNamer resourceNamer = new TestResourceNamer(new TestContextManager(FakeTestClass.DONOTRECORD_FALSE_SKIPINPLAYBACK, TestMode.PLAYBACK), this.getRecordedDataWithValue());
        Assertions.assertNotEquals((Object)A_VARIABLE, (Object)resourceNamer.randomName(RANDOM_NAME_PREFIX, 12));
        Assertions.assertNotEquals((Object)A_VARIABLE, (Object)resourceNamer.randomUuid());
        Assertions.assertNotEquals((Object)A_VARIABLE, (Object)resourceNamer.now());
        Assertions.assertEquals((Object)A_VARIABLE, (Object)resourceNamer.recordValueFromConfig(A_VARIABLE));
    }

    @Test
    public void recordedDataIsNotAllowedToRecordValues() {
        RecordedData recordedData = new RecordedData();
        this.callNamerMethds(new TestResourceNamer(new TestContextManager(FakeTestClass.METHOD_WITHOUT_DONOTRECORD, TestMode.LIVE), recordedData));
        this.validateNoRecordingsMade(new TestResourceNamer(new TestContextManager(FakeTestClass.METHOD_WITHOUT_DONOTRECORD, TestMode.PLAYBACK), recordedData));
        recordedData = new RecordedData();
        this.callNamerMethds(new TestResourceNamer(new TestContextManager(FakeTestClass.DONOTRECORD_FALSE_SKIPINPLAYBACK, TestMode.RECORD), recordedData));
        this.validateNoRecordingsMade(new TestResourceNamer(new TestContextManager(FakeTestClass.METHOD_WITHOUT_DONOTRECORD, TestMode.PLAYBACK), recordedData));
    }

    private void callNamerMethds(TestResourceNamer resourceNamer) {
        resourceNamer.randomName(RANDOM_NAME_PREFIX, 12);
        resourceNamer.randomUuid();
        resourceNamer.now();
        resourceNamer.recordValueFromConfig(CONFIG_VALUE);
    }

    private void validateNoRecordingsMade(TestResourceNamer resourceNamer) {
        this.assertNoSuchElementException(() -> resourceNamer.randomName(RANDOM_NAME_PREFIX, 12));
        this.assertNoSuchElementException(() -> ((TestResourceNamer)resourceNamer).randomUuid());
        this.assertNoSuchElementException(() -> ((TestResourceNamer)resourceNamer).now());
        this.assertNoSuchElementException(() -> resourceNamer.recordValueFromConfig(CONFIG_VALUE));
    }

    private void assertNoSuchElementException(Executable executable) {
        Assertions.assertThrows(NoSuchElementException.class, (Executable)executable, (String)"Expected 'NoSuchElementException' to be thrown.");
    }

    private RecordedData getRecordedDataWithValue() {
        RecordedData recordedData = new RecordedData();
        recordedData.addVariable(A_VARIABLE);
        return recordedData;
    }
}

