/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.PortPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.test.MyRestException;
import com.azure.core.test.implementation.entities.HttpBinFormDataJSON;
import com.azure.core.test.implementation.entities.HttpBinHeaders;
import com.azure.core.test.implementation.entities.HttpBinJSON;
import com.azure.core.util.FluxUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class RestProxyTests {
    protected abstract HttpClient createHttpClient();

    protected abstract int getWireMockPort();

    @Test
    public void syncRequestWithByteArrayReturnType() {
        byte[] result = this.createService(Service1.class).getByteArray();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)100, (int)result.length);
    }

    @Test
    public void asyncRequestWithByteArrayReturnType() {
        StepVerifier.create(this.createService(Service1.class).getByteArrayAsync()).assertNext(bytes -> Assertions.assertEquals((int)100, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void getByteArrayAsyncWithNoExpectedResponses() {
        StepVerifier.create(this.createService(Service1.class).getByteArrayAsyncWithNoExpectedResponses()).assertNext(bytes -> Assertions.assertEquals((int)100, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void syncRequestWithByteArrayReturnTypeAndParameterizedHostAndPath() {
        byte[] result = this.createService(Service2.class).getByteArray("localhost", 100);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)result.length, (int)100);
    }

    @Test
    public void asyncRequestWithByteArrayReturnTypeAndParameterizedHostAndPath() {
        StepVerifier.create(this.createService(Service2.class).getByteArrayAsync("localhost", 100)).assertNext(bytes -> Assertions.assertEquals((int)100, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void syncRequestWithEmptyByteArrayReturnTypeAndParameterizedHostAndPath() {
        byte[] result = this.createService(Service2.class).getByteArray("localhost", 0);
        Assertions.assertNull((Object)result);
    }

    @Test
    public void syncGetRequestWithNoReturn() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service3.class).getNothing());
    }

    @Test
    public void asyncGetRequestWithNoReturn() {
        StepVerifier.create(this.createService(Service3.class).getNothingAsync()).verifyComplete();
    }

    @Test
    public void syncGetRequestWithAnything() {
        HttpBinJSON json = this.createService(Service5.class).getAnything();
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPlus();
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything/with+plus", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParam() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam("withpathparam");
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything/withpathparam", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParamWithSpace() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam("with path param");
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything/with path param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParamWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam("with+path+param");
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything/with+path+param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParam() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam("withpathparam");
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything/withpathparam", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParamWithPercent20() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam("with%20path%20param");
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything/with path param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParamWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam("with+path+param");
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything/with+path+param", json.url());
    }

    @Test
    public void asyncGetRequestWithAnything() {
        StepVerifier.create(this.createService(Service5.class).getAnythingAsync()).assertNext(json -> RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything", json.url())).verifyComplete();
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnything() {
        HttpBinJSON json = this.createService(Service6.class).getAnything("A", 15);
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything?a=A&b=15", json.url());
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnythingWithPercent20() {
        HttpBinJSON json = this.createService(Service6.class).getAnything("A%20Z", 15);
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything?a=A%2520Z&b=15", json.url());
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnythingWithEncodedWithPercent20() {
        HttpBinJSON json = this.createService(Service6.class).getAnythingWithEncoded("x%20y", 15);
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything?a=x y&b=15", json.url());
    }

    @Test
    public void asyncGetRequestWithQueryParametersAndAnything() {
        StepVerifier.create(this.createService(Service6.class).getAnythingAsync("A", 15)).assertNext(json -> RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything?a=A&b=15", json.url())).verifyComplete();
    }

    @Test
    public void syncGetRequestWithNullQueryParameter() {
        HttpBinJSON json = this.createService(Service6.class).getAnything(null, 15);
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything?b=15", json.url());
    }

    @Test
    public void syncGetRequestWithHeaderParametersAndAnythingReturn() {
        HttpBinJSON json = this.createService(Service7.class).getAnything("A", 15);
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
        Assertions.assertNotNull(json.headers());
        HttpHeaders headers = new HttpHeaders().setAll(json.headers());
        Assertions.assertEquals((Object)"A", (Object)headers.getValue("A"));
        Assertions.assertArrayEquals((Object[])new String[]{"A"}, (Object[])headers.getValues("A"));
        Assertions.assertEquals((Object)"15", (Object)headers.getValue("B"));
        Assertions.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues("B"));
    }

    @Test
    public void asyncGetRequestWithHeaderParametersAndAnything() {
        StepVerifier.create(this.createService(Service7.class).getAnythingAsync("A", 15)).assertNext(json -> {
            RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
            Assertions.assertNotNull(json.headers());
            HttpHeaders headers = new HttpHeaders().setAll(json.headers());
            Assertions.assertEquals((Object)"A", (Object)headers.getValue("A"));
            Assertions.assertArrayEquals((Object[])new String[]{"A"}, (Object[])headers.getValues("A"));
            Assertions.assertEquals((Object)"15", (Object)headers.getValue("B"));
            Assertions.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues("B"));
        }).verifyComplete();
    }

    @Test
    public void syncGetRequestWithNullHeader() {
        HttpBinJSON json = this.createService(Service7.class).getAnything(null, 15);
        HttpHeaders headers = new HttpHeaders().setAll(json.headers());
        Assertions.assertNull((Object)headers.getValue("A"));
        Assertions.assertArrayEquals(null, (Object[])headers.getValues("A"));
        Assertions.assertEquals((Object)"15", (Object)headers.getValue("B"));
        Assertions.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues("B"));
    }

    @Test
    public void syncPostRequestWithStringBody() {
        HttpBinJSON json = this.createService(Service8.class).post("I'm a post body!");
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"I'm a post body!", (Object)json.data());
    }

    @Test
    public void asyncPostRequestWithStringBody() {
        StepVerifier.create(this.createService(Service8.class).postAsync("I'm a post body!")).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"I'm a post body!", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncPostRequestWithNullBody() {
        HttpBinJSON result = this.createService(Service8.class).post(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void syncPutRequestWithIntBody() {
        HttpBinJSON json = this.createService(Service9.class).put(42);
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"42", (Object)json.data());
    }

    @Test
    public void asyncPutRequestWithIntBody() {
        StepVerifier.create(this.createService(Service9.class).putAsync(42)).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"42", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncPutRequestWithBodyAndEqualContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        HttpBinJSON json = this.createService(Service9.class).putBodyAndContentLength(body, 4L);
        Assertions.assertEquals((Object)"test", (Object)json.data());
        Assertions.assertEquals((Object)"application/octet-stream", (Object)json.getHeaderValue("Content-Type"));
        Assertions.assertEquals((Object)"4", (Object)json.getHeaderValue("Content-Length"));
    }

    @Test
    public void syncPutRequestWithBodyLessThanContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        UnexpectedLengthException unexpectedLengthException = (UnexpectedLengthException)Assertions.assertThrows(UnexpectedLengthException.class, () -> {
            this.createService(Service9.class).putBodyAndContentLength(body, 5L);
            body.clear();
        });
        Assertions.assertTrue((boolean)unexpectedLengthException.getMessage().contains("less than"));
    }

    @Test
    public void syncPutRequestWithBodyMoreThanContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        UnexpectedLengthException unexpectedLengthException = (UnexpectedLengthException)Assertions.assertThrows(UnexpectedLengthException.class, () -> {
            this.createService(Service9.class).putBodyAndContentLength(body, 3L);
            body.clear();
        });
        Assertions.assertTrue((boolean)unexpectedLengthException.getMessage().contains("more than"));
    }

    @Test
    public void asyncPutRequestWithBodyAndEqualContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength((Flux<ByteBuffer>)body, 4L)).assertNext(json -> {
            Assertions.assertEquals((Object)"test", (Object)json.data());
            Assertions.assertEquals((Object)"application/octet-stream", (Object)json.getHeaderValue("Content-Type"));
            Assertions.assertEquals((Object)"4", (Object)json.getHeaderValue("Content-Length"));
        }).verifyComplete();
    }

    @Test
    public void asyncPutRequestWithBodyAndLessThanContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength((Flux<ByteBuffer>)body, 5L)).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((boolean)(exception instanceof UnexpectedLengthException));
            Assertions.assertTrue((boolean)exception.getMessage().contains("less than"));
        });
    }

    @Test
    public void asyncPutRequestWithBodyAndMoreThanContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength((Flux<ByteBuffer>)body, 3L)).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((boolean)(exception instanceof UnexpectedLengthException));
            Assertions.assertTrue((boolean)exception.getMessage().contains("more than"));
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponse() {
        HttpResponseException e = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service9.class).putWithUnexpectedResponse("I'm the body!"));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
        LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
        Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponse() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAsync("I'm the body!")).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof HttpResponseException));
            HttpResponseException exception = (HttpResponseException)throwable;
            Assertions.assertNotNull((Object)exception.getValue());
            Assertions.assertTrue((boolean)(exception.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)exception.getValue();
            Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndExceptionType() {
        MyRestException e = (MyRestException)((Object)Assertions.assertThrows(MyRestException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndExceptionType("I'm the body!")));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndExceptionTypeAsync("I'm the body!")).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof MyRestException), (String)("Expected MyRestException would be thrown. Instead got " + throwable.getClass().getSimpleName()));
            MyRestException myRestException = (MyRestException)((Object)((Object)throwable));
            Assertions.assertNotNull((Object)myRestException.getValue());
            Assertions.assertEquals((Object)"I'm the body!", (Object)myRestException.getValue().data());
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndDeterminedExceptionType() {
        MyRestException e = (MyRestException)((Object)Assertions.assertThrows(MyRestException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndDeterminedExceptionType("I'm the body!")));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndDeterminedExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndDeterminedExceptionTypeAsync("I'm the body!")).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof MyRestException), (String)("Expected MyRestException would be thrown. Instead got " + throwable.getClass().getSimpleName()));
            MyRestException restException = (MyRestException)((Object)((Object)throwable));
            Assertions.assertNotNull((Object)restException.getValue());
            Assertions.assertEquals((Object)"I'm the body!", (Object)restException.getValue().data());
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndFallthroughExceptionType() {
        MyRestException e = (MyRestException)((Object)Assertions.assertThrows(MyRestException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndFallthroughExceptionType("I'm the body!")));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndFallthroughExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndFallthroughExceptionTypeAsync("I'm the body!")).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof MyRestException), (String)("Expected MyRestException would be thrown. Instead got " + throwable.getClass().getSimpleName()));
            MyRestException restException = (MyRestException)((Object)((Object)throwable));
            Assertions.assertNotNull((Object)restException.getValue());
            Assertions.assertEquals((Object)"I'm the body!", (Object)restException.getValue().data());
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndNoFallthroughExceptionType() {
        HttpResponseException e = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndNoFallthroughExceptionType("I'm the body!"));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
        LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
        Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndNoFallthroughExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndNoFallthroughExceptionTypeAsync("I'm the body!")).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof HttpResponseException), (String)("Expected MyRestException would be thrown. Instead got " + throwable.getClass().getSimpleName()));
            HttpResponseException responseException = (HttpResponseException)throwable;
            Assertions.assertNotNull((Object)responseException.getValue());
            Assertions.assertTrue((boolean)(responseException.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)responseException.getValue();
            Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        });
    }

    @Test
    public void syncHeadRequest() {
        Void body = (Void)this.createService(Service10.class).head().getValue();
        Assertions.assertNull((Object)body);
    }

    @Test
    public void syncHeadBooleanRequest() {
        boolean result = this.createService(Service10.class).headBoolean();
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void syncVoidHeadRequest() {
        this.createService(Service10.class).voidHead();
    }

    @Test
    public void asyncHeadRequest() {
        StepVerifier.create(this.createService(Service10.class).headAsync()).assertNext(response -> Assertions.assertNull((Object)response.getValue())).verifyComplete();
    }

    @Test
    public void asyncHeadBooleanRequest() {
        StepVerifier.create(this.createService(Service10.class).headBooleanAsync()).assertNext(Assertions::assertTrue).verifyComplete();
    }

    @Test
    public void asyncCompletableHeadRequest() {
        StepVerifier.create(this.createService(Service10.class).completableHeadAsync()).verifyComplete();
    }

    @Test
    public void syncDeleteRequest() {
        HttpBinJSON json = this.createService(Service11.class).delete(false);
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"false", (Object)json.data());
    }

    @Test
    public void asyncDeleteRequest() {
        StepVerifier.create(this.createService(Service11.class).deleteAsync(false)).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"false", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncPatchRequest() {
        HttpBinJSON json = this.createService(Service12.class).patch("body-contents");
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"body-contents", (Object)json.data());
    }

    @Test
    public void asyncPatchRequest() {
        StepVerifier.create(this.createService(Service12.class).patchAsync("body-contents")).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"body-contents", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncHeadersRequest() {
        HttpBinJSON json = this.createService(Service13.class).get();
        Assertions.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
        Assertions.assertNotNull(json.headers());
        HttpHeaders headers = new HttpHeaders().setAll(json.headers());
        Assertions.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue("MyHeader"));
        Assertions.assertArrayEquals((Object[])new String[]{"MyHeaderValue"}, (Object[])headers.getValues("MyHeader"));
        Assertions.assertEquals((Object)"My,Header,Value", (Object)headers.getValue("MyOtherHeader"));
        Assertions.assertArrayEquals((Object[])new String[]{"My", "Header", "Value"}, (Object[])headers.getValues("MyOtherHeader"));
    }

    @Test
    public void asyncHeadersRequest() {
        StepVerifier.create(this.createService(Service13.class).getAsync()).assertNext(json -> {
            RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
            Assertions.assertNotNull(json.headers());
            HttpHeaders headers = new HttpHeaders().setAll(json.headers());
            Assertions.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue("MyHeader"));
            Assertions.assertArrayEquals((Object[])new String[]{"MyHeaderValue"}, (Object[])headers.getValues("MyHeader"));
        }).verifyComplete();
    }

    @Test
    public void asyncHttpsHeadersRequest() {
        StepVerifier.create(this.createService(Service14.class).getAsync()).assertNext(json -> {
            RestProxyTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
            Assertions.assertNotNull(json.headers());
            HttpHeaders headers = new HttpHeaders().setAll(json.headers());
            Assertions.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue("MyHeader"));
        }).verifyComplete();
    }

    @Test
    public void service16Put() {
        Service16 service16 = this.createService(Service16.class);
        byte[] expectedBytes = new byte[]{1, 2, 3, 4};
        HttpBinJSON httpBinJSON = service16.putByteArray(expectedBytes);
        Assertions.assertTrue((boolean)(httpBinJSON.data() instanceof String));
        String base64String = (String)httpBinJSON.data();
        byte[] actualBytes = base64String.getBytes();
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
    }

    @Test
    public void service16PutAsync() {
        byte[] expectedBytes = new byte[]{1, 2, 3, 4};
        StepVerifier.create(this.createService(Service16.class).putByteArrayAsync(expectedBytes)).assertNext(json -> {
            Assertions.assertTrue((boolean)(json.data() instanceof String));
            Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])((String)json.data()).getBytes());
        }).verifyComplete();
    }

    @Test
    public void syncRequestWithMultipleHostParams() {
        HttpBinJSON result = this.createService(Service17.class).get("local", "host");
        Assertions.assertNotNull((Object)result);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/get", result.url());
    }

    @Test
    public void asyncRequestWithMultipleHostParams() {
        StepVerifier.create(this.createService(Service17.class).getAsync("local", "host")).assertNext(json -> RestProxyTests.assertMatchWithHttpOrHttps("localhost/get", json.url())).verifyComplete();
    }

    @Test
    public void service18GetStatus200() {
        this.createService(Service18.class).getStatus200();
    }

    @Test
    public void service18GetStatus200WithExpectedResponse200() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus200WithExpectedResponse200());
    }

    @Test
    public void service18GetStatus300() {
        this.createService(Service18.class).getStatus300();
    }

    @Test
    public void service18GetStatus300WithExpectedResponse300() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus300WithExpectedResponse300());
    }

    @Test
    public void service18GetStatus400() {
        Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service18.class).getStatus400());
    }

    @Test
    public void service18GetStatus400WithExpectedResponse400() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus400WithExpectedResponse400());
    }

    @Test
    public void service18GetStatus500() {
        Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service18.class).getStatus500());
    }

    @Test
    public void service18GetStatus500WithExpectedResponse500() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus500WithExpectedResponse500());
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody("");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody("hello");
        Assertions.assertEquals((Object)"hello", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(new byte[0]);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody("");
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody("soups and stuff");
        Assertions.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(new byte[0]);
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)"\"AAECAwQ=\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody("");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody("soups and stuff");
        Assertions.assertEquals((Object)"soups and stuff", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody("");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody("penguins");
        Assertions.assertEquals((Object)"penguins", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(new byte[0]);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody("");
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody("soups and stuff");
        Assertions.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody("");
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody("soups and stuff");
        Assertions.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(new byte[0]);
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)"\"AAECAwQ=\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody("");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody("penguins");
        Assertions.assertEquals((Object)"penguins", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(new byte[0]);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service20GetBytes100OnlyHeaders() {
        ResponseBase<HttpBinHeaders, Void> response = this.createService(Service20.class).getBytes100OnlyHeaders();
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetBytes100BodyAndHeaders() {
        ResponseBase<HttpBinHeaders, byte[]> response = this.createService(Service20.class).getBytes100BodyAndHeaders();
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        byte[] body = (byte[])response.getValue();
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((int)100, (int)body.length);
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetBytesOnlyStatus() {
        ResponseBase<Void, Void> response = this.createService(Service20.class).getBytesOnlyStatus();
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void service20GetBytesOnlyHeaders() {
        ResponseBase<HttpHeaders, Void> response = this.createService(Service20.class).getBytes100OnlyRawHeaders();
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertNotNull((Object)response.getHeaders());
        Assertions.assertNotEquals((int)0, (int)response.getHeaders().getSize());
    }

    @Test
    public void service20PutOnlyHeaders() {
        ResponseBase<HttpBinHeaders, Void> response = this.createService(Service20.class).putOnlyHeaders("body string");
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20PutBodyAndHeaders() {
        ResponseBase<HttpBinHeaders, HttpBinJSON> response = this.createService(Service20.class).putBodyAndHeaders("body string");
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        HttpBinJSON body = (HttpBinJSON)response.getValue();
        Assertions.assertNotNull((Object)body);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/put", body.url());
        Assertions.assertEquals((Object)"body string", (Object)body.data());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetVoidResponse() {
        Response<Void> response = this.createService(Service20.class).getVoidResponse();
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void service20GetResponseBody() {
        Response<HttpBinJSON> response = this.createService(Service20.class).putBody("body string");
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        HttpBinJSON body = (HttpBinJSON)response.getValue();
        Assertions.assertNotNull((Object)body);
        RestProxyTests.assertMatchWithHttpOrHttps("localhost/put", body.url());
        Assertions.assertEquals((Object)"body string", (Object)body.data());
        HttpHeaders headers = response.getHeaders();
        Assertions.assertNotNull((Object)headers);
    }

    @Test
    public void unexpectedHTTPOK() {
        HttpResponseException e = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> this.createService(UnexpectedOKService.class).getBytes());
        Assertions.assertEquals((Object)"Status code 200, (1024-byte body)", (Object)e.getMessage());
    }

    @Test
    public void service21GetBytes100() {
        byte[] bytes = this.createService(Service21.class).getBytes100();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)100, (int)bytes.length);
    }

    @Test
    public void simpleDownloadTest() {
        StepVerifier.create((Publisher)Flux.using(() -> this.createService(DownloadService.class).getBytes(), response -> response.getValue().map(Buffer::remaining).reduce((Object)0, Integer::sum), StreamResponse::close)).assertNext(count -> Assertions.assertEquals((int)30720, (Integer)count)).verifyComplete();
    }

    @Test
    public void rawFluxDownloadTest() {
        StepVerifier.create((Publisher)this.createService(DownloadService.class).getBytesFlux().map(Buffer::remaining).reduce((Object)0, Integer::sum)).assertNext(count -> Assertions.assertEquals((int)30720, (Integer)count)).verifyComplete();
    }

    @Test
    public void fluxUploadTest() throws Exception {
        Path filePath = Paths.get(this.getClass().getClassLoader().getResource("upload.txt").toURI());
        Flux stream = FluxUtil.readFile((AsynchronousFileChannel)AsynchronousFileChannel.open(filePath, new OpenOption[0]));
        HttpClient httpClient = this.createHttpClient();
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(httpClient).policies(new HttpPipelinePolicy[]{new PortPolicy(this.getWireMockPort(), true), new HttpLoggingPolicy(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS))}).build();
        Response<HttpBinJSON> response = ((FluxUploadService)RestProxy.create(FluxUploadService.class, (HttpPipeline)httpPipeline)).put((Flux<ByteBuffer>)stream, Files.size(filePath));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)((HttpBinJSON)response.getValue()).data());
    }

    @Test
    public void segmentUploadTest() throws Exception {
        Path filePath = Paths.get(this.getClass().getClassLoader().getResource("upload.txt").toURI());
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(filePath, StandardOpenOption.READ);
        Response<HttpBinJSON> response = this.createService(FluxUploadService.class).put((Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel, (long)4L, (long)15L), 15L);
        Assertions.assertEquals((Object)"quick brown fox", (Object)((HttpBinJSON)response.getValue()).data());
    }

    @Test
    public void service22GetBytes() {
        byte[] bytes = this.createService(Service22.class).getBytes("http://localhost/bytes/27");
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)27, (int)bytes.length);
    }

    @Test
    public void service23GetBytes() {
        byte[] bytes = this.createService(Service23.class).getBytes();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)28, (int)bytes.length);
    }

    @Test
    public void service24Put() {
        HashMap<String, String> headerCollection = new HashMap<String, String>();
        headerCollection.put("DEF", "GHIJ");
        headerCollection.put("123", "45");
        HttpBinJSON result = this.createService(Service24.class).put(headerCollection);
        Assertions.assertNotNull(result.headers());
        HttpHeaders resultHeaders = new HttpHeaders().setAll(result.headers());
        Assertions.assertEquals((Object)"GHIJ", (Object)resultHeaders.getValue("ABCDEF"));
        Assertions.assertEquals((Object)"45", (Object)resultHeaders.getValue("ABC123"));
    }

    @Test
    public void postUrlForm() {
        Service26 service = this.createService(Service26.class);
        HttpBinFormDataJSON response = service.postForm("Foo", "123", "foo@bar.com", HttpBinFormDataJSON.PizzaSize.LARGE, Arrays.asList("Bacon", "Onion"));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.form());
        Assertions.assertEquals((Object)"Foo", (Object)response.form().customerName());
        Assertions.assertEquals((Object)"123", (Object)response.form().customerTelephone());
        Assertions.assertEquals((Object)"foo%40bar.com", (Object)response.form().customerEmail());
        Assertions.assertEquals((Object)((Object)HttpBinFormDataJSON.PizzaSize.LARGE), (Object)((Object)response.form().pizzaSize()));
        Assertions.assertEquals((int)2, (int)response.form().toppings().size());
        Assertions.assertEquals((Object)"Bacon", (Object)response.form().toppings().get(0));
        Assertions.assertEquals((Object)"Onion", (Object)response.form().toppings().get(1));
    }

    @Test
    public void postUrlFormEncoded() {
        Service26 service = this.createService(Service26.class);
        HttpBinFormDataJSON response = service.postEncodedForm("Foo", "123", "foo@bar.com", HttpBinFormDataJSON.PizzaSize.LARGE, Arrays.asList("Bacon", "Onion"));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.form());
        Assertions.assertEquals((Object)"Foo", (Object)response.form().customerName());
        Assertions.assertEquals((Object)"123", (Object)response.form().customerTelephone());
        Assertions.assertEquals((Object)"foo@bar.com", (Object)response.form().customerEmail());
        Assertions.assertEquals((Object)((Object)HttpBinFormDataJSON.PizzaSize.LARGE), (Object)((Object)response.form().pizzaSize()));
        Assertions.assertEquals((int)2, (int)response.form().toppings().size());
        Assertions.assertEquals((Object)"Bacon", (Object)response.form().toppings().get(0));
        Assertions.assertEquals((Object)"Onion", (Object)response.form().toppings().get(1));
    }

    protected <T> T createService(Class<T> serviceClass) {
        HttpClient httpClient = this.createHttpClient();
        return this.createService(serviceClass, httpClient);
    }

    protected <T> T createService(Class<T> serviceClass, HttpClient httpClient) {
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new PortPolicy(this.getWireMockPort(), true)}).httpClient(httpClient).build();
        return (T)RestProxy.create(serviceClass, (HttpPipeline)httpPipeline);
    }

    private static void assertMatchWithHttpOrHttps(String url1, String url2) {
        String s1 = "http://" + url1;
        if (s1.equalsIgnoreCase(url2)) {
            return;
        }
        String s2 = "https://" + url1;
        if (s2.equalsIgnoreCase(url2)) {
            return;
        }
        Assertions.fail((String)("'" + url2 + "' does not match with '" + s1 + "' or '" + s2 + "'."));
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service26")
    static interface Service26 {
        @Post(value="post")
        public HttpBinFormDataJSON postForm(@FormParam(value="custname") String var1, @FormParam(value="custtel") String var2, @FormParam(value="custemail") String var3, @FormParam(value="size") HttpBinFormDataJSON.PizzaSize var4, @FormParam(value="toppings") List<String> var5);

        @Post(value="post")
        public HttpBinFormDataJSON postEncodedForm(@FormParam(value="custname") String var1, @FormParam(value="custtel") String var2, @FormParam(value="custemail", encoded=true) String var3, @FormParam(value="size") HttpBinFormDataJSON.PizzaSize var4, @FormParam(value="toppings") List<String> var5);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service24")
    static interface Service24 {
        @Put(value="put")
        public HttpBinJSON put(@HeaderParam(value="ABC") Map<String, String> var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service23")
    static interface Service23 {
        @Get(value="bytes/28")
        public byte[] getBytes();
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service22")
    static interface Service22 {
        @Get(value="/")
        public byte[] getBytes(@HostParam(value="url") String var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="FluxUploadService")
    static interface FluxUploadService {
        @Put(value="/put")
        public Response<HttpBinJSON> put(@BodyParam(value="text/plain") Flux<ByteBuffer> var1, @HeaderParam(value="Content-Length") long var2);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="DownloadService")
    static interface DownloadService {
        @Get(value="/bytes/30720")
        public StreamResponse getBytes();

        @Get(value="/bytes/30720")
        public Flux<ByteBuffer> getBytesFlux();
    }

    @Host(value="https://www.example.com")
    @ServiceInterface(name="Service21")
    private static interface Service21 {
        @Get(value="http://localhost/bytes/100")
        @ExpectedResponses(value={200})
        public byte[] getBytes100();
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="UnexpectedOKService")
    static interface UnexpectedOKService {
        @Get(value="/bytes/1024")
        @ExpectedResponses(value={400})
        public StreamResponse getBytes();
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service20")
    private static interface Service20 {
        @Get(value="bytes/100")
        public ResponseBase<HttpBinHeaders, Void> getBytes100OnlyHeaders();

        @Get(value="bytes/100")
        public ResponseBase<HttpHeaders, Void> getBytes100OnlyRawHeaders();

        @Get(value="bytes/100")
        public ResponseBase<HttpBinHeaders, byte[]> getBytes100BodyAndHeaders();

        @Put(value="put")
        public ResponseBase<HttpBinHeaders, Void> putOnlyHeaders(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        public ResponseBase<HttpBinHeaders, HttpBinJSON> putBodyAndHeaders(@BodyParam(value="application/octet-stream") String var1);

        @Get(value="bytes/100")
        public ResponseBase<Void, Void> getBytesOnlyStatus();

        @Get(value="bytes/100")
        public Response<Void> getVoidResponse();

        @Put(value="put")
        public Response<HttpBinJSON> putBody(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service19")
    private static interface Service19 {
        @Put(value="put")
        public HttpBinJSON putWithNoContentTypeAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        public HttpBinJSON putWithNoContentTypeAndByteArrayBody(@BodyParam(value="application/octet-stream") byte[] var1);

        @Put(value="put")
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndStringBody(@BodyParam(value="application/json") String var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/json"})
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndByteArrayBody(@BodyParam(value="application/json") byte[] var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/octet-stream"})
        public HttpBinJSON putWithHeaderApplicationOctetStreamContentTypeAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/octet-stream"})
        public HttpBinJSON putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(@BodyParam(value="application/octet-stream") byte[] var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndStringBody(@BodyParam(value="application/json") String var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(@BodyParam(value="application/json; charset=utf-8") String var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(@BodyParam(value="application/json") byte[] var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(@BodyParam(value="application/octet-stream") byte[] var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service18")
    private static interface Service18 {
        @Get(value="status/200")
        public void getStatus200();

        @Get(value="status/200")
        @ExpectedResponses(value={200})
        public void getStatus200WithExpectedResponse200();

        @Get(value="status/300")
        public void getStatus300();

        @Get(value="status/300")
        @ExpectedResponses(value={300})
        public void getStatus300WithExpectedResponse300();

        @Get(value="status/400")
        public void getStatus400();

        @Get(value="status/400")
        @ExpectedResponses(value={400})
        public void getStatus400WithExpectedResponse400();

        @Get(value="status/500")
        public void getStatus500();

        @Get(value="status/500")
        @ExpectedResponses(value={500})
        public void getStatus500WithExpectedResponse500();
    }

    @Host(value="http://{hostPart1}{hostPart2}")
    @ServiceInterface(name="Service17")
    private static interface Service17 {
        @Get(value="get")
        @ExpectedResponses(value={200})
        public HttpBinJSON get(@HostParam(value="hostPart1") String var1, @HostParam(value="hostPart2") String var2);

        @Get(value="get")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAsync(@HostParam(value="hostPart1") String var1, @HostParam(value="hostPart2") String var2);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service16")
    private static interface Service16 {
        @Put(value="put")
        @ExpectedResponses(value={200})
        public HttpBinJSON putByteArray(@BodyParam(value="application/octet-stream") byte[] var1);

        @Put(value="put")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> putByteArrayAsync(@BodyParam(value="application/octet-stream") byte[] var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service14")
    private static interface Service14 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue"})
        public HttpBinJSON get();

        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue"})
        public Mono<HttpBinJSON> getAsync();
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service13")
    private static interface Service13 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue", "MyOtherHeader:My,Header,Value"})
        public HttpBinJSON get();

        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue", "MyOtherHeader:My,Header,Value"})
        public Mono<HttpBinJSON> getAsync();
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service12")
    private static interface Service12 {
        @Patch(value="patch")
        @ExpectedResponses(value={200})
        public HttpBinJSON patch(@BodyParam(value="application/octet-stream") String var1);

        @Patch(value="patch")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> patchAsync(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service11")
    private static interface Service11 {
        @Delete(value="delete")
        @ExpectedResponses(value={200})
        public HttpBinJSON delete(@BodyParam(value="application/octet-stream") boolean var1);

        @Delete(value="delete")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> deleteAsync(@BodyParam(value="application/octet-stream") boolean var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service10")
    private static interface Service10 {
        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Response<Void> head();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public boolean headBoolean();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public void voidHead();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Response<Void>> headAsync();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Boolean> headBooleanAsync();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Void> completableHeadAsync();
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service9")
    private static interface Service9 {
        @Put(value="put")
        @ExpectedResponses(value={200})
        public HttpBinJSON put(@BodyParam(value="application/octet-stream") int var1);

        @Put(value="put")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> putAsync(@BodyParam(value="application/octet-stream") int var1);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public HttpBinJSON putBodyAndContentLength(@BodyParam(value="application/octet-stream") ByteBuffer var1, @HeaderParam(value="Content-Length") long var2);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public Mono<HttpBinJSON> putAsyncBodyAndContentLength(@BodyParam(value="application/octet-stream") Flux<ByteBuffer> var1, @HeaderParam(value="Content-Length") long var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        public HttpBinJSON putWithUnexpectedResponse(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public HttpBinJSON putWithUnexpectedResponseAndExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={200}, value=MyRestException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public HttpBinJSON putWithUnexpectedResponseAndDeterminedExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={200}, value=MyRestException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndDeterminedExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyRestException.class)})
        public HttpBinJSON putWithUnexpectedResponseAndFallthroughExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyRestException.class)})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndFallthroughExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(code={400}, value=MyRestException.class)
        public HttpBinJSON putWithUnexpectedResponseAndNoFallthroughExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(code={400}, value=MyRestException.class)
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndNoFallthroughExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service8")
    private static interface Service8 {
        @Post(value="post")
        @ExpectedResponses(value={200})
        public HttpBinJSON post(@BodyParam(value="application/octet-stream") String var1);

        @Post(value="post")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> postAsync(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service7")
    private static interface Service7 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything(@HeaderParam(value="a") String var1, @HeaderParam(value="b") int var2);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync(@HeaderParam(value="a") String var1, @HeaderParam(value="b") int var2);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service6")
    private static interface Service6 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything(@QueryParam(value="a") String var1, @QueryParam(value="b") int var2);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithEncoded(@QueryParam(value="a", encoded=true) String var1, @QueryParam(value="b") int var2);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync(@QueryParam(value="a") String var1, @QueryParam(value="b") int var2);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service5")
    private static interface Service5 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything();

        @Get(value="anything/with+plus")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithPlus();

        @Get(value="anything/{path}")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithPathParam(@PathParam(value="path") String var1);

        @Get(value="anything/{path}")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithEncodedPathParam(@PathParam(value="path", encoded=true) String var1);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync();
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service3")
    private static interface Service3 {
        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public void getNothing();

        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public Mono<Void> getNothingAsync();
    }

    @Host(value="http://{hostName}")
    @ServiceInterface(name="Service2")
    private static interface Service2 {
        @Get(value="bytes/{numberOfBytes}")
        @ExpectedResponses(value={200})
        public byte[] getByteArray(@HostParam(value="hostName") String var1, @PathParam(value="numberOfBytes") int var2);

        @Get(value="bytes/{numberOfBytes}")
        @ExpectedResponses(value={200})
        public Mono<byte[]> getByteArrayAsync(@HostParam(value="hostName") String var1, @PathParam(value="numberOfBytes") int var2);
    }

    @Host(value="http://localhost")
    @ServiceInterface(name="Service1")
    private static interface Service1 {
        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public byte[] getByteArray();

        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public Mono<byte[]> getByteArrayAsync();

        @Get(value="bytes/100")
        public Mono<byte[]> getByteArrayAsyncWithNoExpectedResponses();
    }
}

