/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.AfterRetryPolicyProvider;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.tracing.opentelemetry.implementation.HttpTraceUtil;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.net.URL;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.ContextView;

public class OpenTelemetryHttpPolicy
implements AfterRetryPolicyProvider,
HttpPipelinePolicy {
    private static final Tracer TRACER = GlobalOpenTelemetry.getTracer((String)"Azure-OpenTelemetry");
    private static final String HTTP_USER_AGENT = "http.user_agent";
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String REQUEST_ID = "x-ms-request-id";
    private final TextMapPropagator traceContextFormat = W3CTraceContextPropagator.getInstance();
    private final TextMapSetter<HttpRequest> contextSetter = (request, key, value) -> request.getHeaders().set(key, value);

    public HttpPipelinePolicy create() {
        return this;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        SpanContext spanContext;
        if (context.getData("disable-tracing").orElse(false).booleanValue()) {
            return next.process();
        }
        Span parentSpan = context.getData("parent-span").orElse(Span.current());
        HttpRequest request = context.getHttpRequest();
        UrlBuilder urlBuilder = UrlBuilder.parse((URL)context.getHttpRequest().getUrl());
        SpanBuilder spanBuilder = TRACER.spanBuilder(urlBuilder.getPath()).setParent(Context.current().with((ImplicitContextKeyed)parentSpan));
        spanBuilder.setSpanKind(SpanKind.CLIENT);
        Span span = spanBuilder.startSpan();
        if (span.isRecording()) {
            OpenTelemetryHttpPolicy.addSpanRequestAttributes(span, request, context);
        }
        if ((spanContext = span.getSpanContext()).isValid()) {
            this.traceContextFormat.inject(Context.current(), (Object)request, this.contextSetter);
        }
        return next.process().doOnEach(OpenTelemetryHttpPolicy::handleResponse).contextWrite((ContextView)reactor.util.context.Context.of((Object)"TRACING_SPAN", (Object)span, (Object)"REQUEST", (Object)request));
    }

    private static void addSpanRequestAttributes(Span span, HttpRequest request, HttpPipelineCallContext context) {
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, HTTP_USER_AGENT, request.getHeaders().getValue("User-Agent"));
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, HTTP_METHOD, request.getHttpMethod().toString());
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, HTTP_URL, request.getUrl().toString());
        Optional tracingNamespace = context.getData("az.namespace");
        if (tracingNamespace.isPresent()) {
            OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, "az.namespace", tracingNamespace.get().toString());
        }
    }

    private static void putAttributeIfNotEmptyOrNull(Span span, String key, String value) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)value)) {
            span.setAttribute(AttributeKey.stringKey((String)key), (Object)value);
        }
    }

    private static void handleResponse(Signal<? extends HttpResponse> signal) {
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        ContextView context = signal.getContextView();
        Optional tracingSpan = context.getOrEmpty((Object)"TRACING_SPAN");
        if (!tracingSpan.isPresent()) {
            return;
        }
        Span span = (Span)tracingSpan.get();
        HttpResponse httpResponse = null;
        Throwable error = null;
        if (signal.isOnNext()) {
            httpResponse = (HttpResponse)signal.get();
        } else {
            error = signal.getThrowable();
            if (error instanceof HttpResponseException) {
                HttpResponseException exception = (HttpResponseException)error;
                httpResponse = exception.getResponse();
            }
        }
        OpenTelemetryHttpPolicy.spanEnd(span, httpResponse, error);
    }

    private static void spanEnd(Span span, HttpResponse response, Throwable error) {
        if (span.isRecording()) {
            int statusCode = 0;
            String requestId = null;
            if (response != null) {
                statusCode = response.getStatusCode();
                requestId = response.getHeaderValue(REQUEST_ID);
            }
            OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, REQUEST_ID, requestId);
            span.setAttribute(HTTP_STATUS_CODE, (long)statusCode);
            span = HttpTraceUtil.setSpanStatus(span, statusCode, error);
        }
        span.end();
    }
}

