/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry;

import com.azure.core.tracing.opentelemetry.implementation.AmqpPropagationFormatUtil;
import com.azure.core.tracing.opentelemetry.implementation.AmqpTraceUtil;
import com.azure.core.tracing.opentelemetry.implementation.HttpTraceUtil;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

public class OpenTelemetryTracer
implements com.azure.core.util.tracing.Tracer {
    private final Tracer tracer;
    static final String AZ_NAMESPACE_KEY = "az.namespace";
    static final String MESSAGE_BUS_DESTINATION = "message_bus.destination";
    static final String PEER_ENDPOINT = "peer.address";
    private final ClientLogger logger = new ClientLogger(OpenTelemetryTracer.class);
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};

    public OpenTelemetryTracer() {
        this(GlobalOpenTelemetry.getTracer((String)"Azure-OpenTelemetry"));
    }

    OpenTelemetryTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public com.azure.core.util.Context start(String spanName, com.azure.core.util.Context context) {
        Objects.requireNonNull(spanName, "'spanName' cannot be null.");
        SpanBuilder spanBuilder = this.createSpanBuilder(spanName, null, io.opentelemetry.api.trace.SpanKind.INTERNAL, null, context);
        return this.startSpanInternal(spanBuilder, null, context);
    }

    public com.azure.core.util.Context start(String spanName, StartSpanOptions options, com.azure.core.util.Context context) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        SpanBuilder spanBuilder = this.createSpanBuilder(spanName, null, this.convertToOtelKind(options.getSpanKind()), options.getAttributes(), context);
        return this.startSpanInternal(spanBuilder, null, context);
    }

    public com.azure.core.util.Context start(String spanName, com.azure.core.util.Context context, ProcessKind processKind) {
        Objects.requireNonNull(spanName, "'spanName' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(processKind, "'processKind' cannot be null.");
        switch (processKind) {
            case SEND: {
                SpanBuilder spanBuilder = this.getOrNull(context, "builder", SpanBuilder.class);
                if (spanBuilder == null) {
                    return context;
                }
                return this.startSpanInternal(spanBuilder, this::addMessagingAttributes, context);
            }
            case MESSAGE: {
                SpanBuilder spanBuilder = this.createSpanBuilder(spanName, null, io.opentelemetry.api.trace.SpanKind.PRODUCER, null, context);
                context = this.startSpanInternal(spanBuilder, this::addMessagingAttributes, context);
                return this.setDiagnosticId(context);
            }
            case PROCESS: {
                SpanContext remoteParentContext = this.getOrNull(context, "span-context", SpanContext.class);
                SpanBuilder spanBuilder = this.createSpanBuilder(spanName, remoteParentContext, io.opentelemetry.api.trace.SpanKind.CONSUMER, null, context);
                context = this.startSpanInternal(spanBuilder, this::addMessagingAttributes, context);
                return context.addData((Object)"scope", (Object)this.makeSpanCurrent(context));
            }
        }
        return context;
    }

    public void end(int responseCode, Throwable throwable, com.azure.core.util.Context context) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        Span span = this.getSpanOrNull(context);
        if (span == null) {
            return;
        }
        if (span.isRecording()) {
            HttpTraceUtil.setSpanStatus(span, responseCode, throwable);
        }
        span.end();
    }

    public void setAttribute(String key, String value, com.azure.core.util.Context context) {
        Objects.requireNonNull(context, "'context' cannot be null");
        if (CoreUtils.isNullOrEmpty((CharSequence)value)) {
            this.logger.verbose("Failed to set span attribute since value is null or empty.");
            return;
        }
        Span span = this.getSpanOrNull(context);
        if (span == null) {
            return;
        }
        if (span.isRecording()) {
            span.setAttribute(key, value);
        }
    }

    public com.azure.core.util.Context setSpanName(String spanName, com.azure.core.util.Context context) {
        return context.addData((Object)"user-span-name", (Object)spanName);
    }

    public void end(String statusMessage, Throwable throwable, com.azure.core.util.Context context) {
        Span span = this.getSpanOrNull(context);
        if (span == null) {
            return;
        }
        if (span.isRecording()) {
            span = AmqpTraceUtil.parseStatusMessage(span, statusMessage, throwable);
        }
        span.end();
        this.endScope(context);
    }

    public void addLink(com.azure.core.util.Context context) {
        SpanBuilder spanBuilder = this.getOrNull(context, "builder", SpanBuilder.class);
        if (spanBuilder == null) {
            return;
        }
        SpanContext spanContext = this.getOrNull(context, "span-context", SpanContext.class);
        if (spanContext == null) {
            return;
        }
        spanBuilder.addLink(spanContext);
    }

    public com.azure.core.util.Context extractContext(String diagnosticId, com.azure.core.util.Context context) {
        return AmqpPropagationFormatUtil.extractContext(diagnosticId, context);
    }

    public com.azure.core.util.Context getSharedSpanBuilder(String spanName, com.azure.core.util.Context context) {
        return context.addData((Object)"builder", (Object)this.createSpanBuilder(spanName, null, io.opentelemetry.api.trace.SpanKind.CLIENT, null, context));
    }

    public AutoCloseable makeSpanCurrent(com.azure.core.util.Context context) {
        Context traceContext = this.getTraceContextOrDefault(context, null);
        if (traceContext == null) {
            this.logger.verbose("There is no OpenTelemetry Context on the context, cannot make it current");
            return NOOP_CLOSEABLE;
        }
        return traceContext.makeCurrent();
    }

    public void addEvent(String eventName, Map<String, Object> traceEventAttributes, OffsetDateTime timestamp) {
        this.addEvent(eventName, traceEventAttributes, timestamp, new com.azure.core.util.Context((Object)"trace-context", (Object)Context.current()));
    }

    public void addEvent(String eventName, Map<String, Object> traceEventAttributes, OffsetDateTime timestamp, com.azure.core.util.Context context) {
        Objects.requireNonNull(eventName, "'eventName' cannot be null.");
        Span currentSpan = this.getSpanOrNull(context);
        if (currentSpan == null) {
            this.logger.verbose("There is no OpenTelemetry Span or Context on the context, cannot add event");
            return;
        }
        if (timestamp == null) {
            currentSpan.addEvent(eventName, traceEventAttributes == null ? Attributes.empty() : this.convertToOtelAttributes(traceEventAttributes));
        } else {
            currentSpan.addEvent(eventName, traceEventAttributes == null ? Attributes.empty() : this.convertToOtelAttributes(traceEventAttributes), timestamp.toInstant());
        }
    }

    private com.azure.core.util.Context startSpanInternal(SpanBuilder spanBuilder, BiConsumer<Span, com.azure.core.util.Context> setAttributes, com.azure.core.util.Context context) {
        Objects.requireNonNull(spanBuilder, "'spanBuilder' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        Span span = spanBuilder.startSpan();
        if (span.isRecording()) {
            String tracingNamespace = this.getOrNull(context, AZ_NAMESPACE_KEY, String.class);
            if (tracingNamespace != null) {
                span.setAttribute(AZ_NAMESPACE_KEY, tracingNamespace);
            }
            if (setAttributes != null) {
                setAttributes.accept(span, context);
            }
        }
        return context.addData((Object)"trace-context", (Object)this.getTraceContextOrDefault(context, Context.current()).with((ImplicitContextKeyed)span));
    }

    private SpanBuilder createSpanBuilder(String spanName, SpanContext remoteParentContext, io.opentelemetry.api.trace.SpanKind spanKind, Map<String, Object> beforeSaplingAttributes, com.azure.core.util.Context context) {
        String spanNameKey = this.getOrNull(context, "user-span-name", String.class);
        if (spanNameKey == null) {
            spanNameKey = spanName;
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanNameKey).setSpanKind(spanKind);
        Context parentContext = this.getTraceContextOrDefault(context, Context.current());
        if (remoteParentContext != null) {
            spanBuilder.setParent(parentContext.with((ImplicitContextKeyed)Span.wrap((SpanContext)remoteParentContext)));
        } else {
            spanBuilder.setParent(parentContext);
        }
        if (!CoreUtils.isNullOrEmpty(beforeSaplingAttributes)) {
            Attributes otelAttributes = this.convertToOtelAttributes(beforeSaplingAttributes);
            otelAttributes.forEach((key, value) -> spanBuilder.setAttribute(key, value));
        }
        return spanBuilder;
    }

    private void endScope(com.azure.core.util.Context context) {
        Scope scope = this.getOrNull(context, "scope", Scope.class);
        if (scope != null) {
            scope.close();
        }
    }

    private io.opentelemetry.api.trace.SpanKind convertToOtelKind(SpanKind kind) {
        switch (kind) {
            case CLIENT: {
                return io.opentelemetry.api.trace.SpanKind.CLIENT;
            }
            case SERVER: {
                return io.opentelemetry.api.trace.SpanKind.SERVER;
            }
            case CONSUMER: {
                return io.opentelemetry.api.trace.SpanKind.CONSUMER;
            }
            case PRODUCER: {
                return io.opentelemetry.api.trace.SpanKind.PRODUCER;
            }
        }
        return io.opentelemetry.api.trace.SpanKind.INTERNAL;
    }

    private Attributes convertToOtelAttributes(Map<String, Object> attributes) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((key, value) -> {
            if (value instanceof Boolean) {
                attributesBuilder.put(key, ((Boolean)value).booleanValue());
            } else if (value instanceof String) {
                attributesBuilder.put(key, String.valueOf(value));
            } else if (value instanceof Double) {
                attributesBuilder.put(key, ((Double)value).doubleValue());
            } else if (value instanceof Long) {
                attributesBuilder.put(key, ((Long)value).longValue());
            } else if (value instanceof String[]) {
                attributesBuilder.put(key, (String[])value);
            } else if (value instanceof long[]) {
                attributesBuilder.put(key, (long[])value);
            } else if (value instanceof double[]) {
                attributesBuilder.put(key, (double[])value);
            } else if (value instanceof boolean[]) {
                attributesBuilder.put(key, (boolean[])value);
            } else {
                this.logger.warning("Could not populate attribute with key '{}', type is not supported.");
            }
        });
        return attributesBuilder.build();
    }

    private com.azure.core.util.Context setDiagnosticId(com.azure.core.util.Context context) {
        Span span = this.getSpanOrNull(context);
        if (span == null) {
            return context;
        }
        SpanContext spanContext = span.getSpanContext();
        if (spanContext.isValid()) {
            String traceparent = AmqpPropagationFormatUtil.getDiagnosticId(spanContext);
            if (traceparent == null) {
                return context;
            }
            return context.addData((Object)"Diagnostic-Id", (Object)traceparent).addData((Object)"span-context", (Object)spanContext);
        }
        return context;
    }

    private void addMessagingAttributes(Span span, com.azure.core.util.Context context) {
        Long messageEnqueuedTime;
        String hostName;
        Objects.requireNonNull(span, "'span' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        String entityPath = this.getOrNull(context, "entity-path", String.class);
        if (entityPath != null) {
            span.setAttribute(MESSAGE_BUS_DESTINATION, entityPath);
        }
        if ((hostName = this.getOrNull(context, "hostname", String.class)) != null) {
            span.setAttribute(PEER_ENDPOINT, hostName);
        }
        if ((messageEnqueuedTime = this.getOrNull(context, "x-opt-enqueued-time", Long.class)) != null) {
            span.setAttribute("x-opt-enqueued-time", messageEnqueuedTime.longValue());
        }
    }

    private <T> T getOrNull(com.azure.core.util.Context context, String key, Class<T> clazz) {
        Optional optional = context.getData((Object)key);
        Object result = optional.filter(value -> clazz.isAssignableFrom(value.getClass())).orElseGet(() -> {
            this.logger.verbose("Could not extract key '{}' of type '{}' from context.", new Object[]{key, clazz});
            return null;
        });
        return (T)result;
    }

    private Context getTraceContextOrDefault(com.azure.core.util.Context azContext, Context defaultContext) {
        Span parentSpan;
        Context traceContext = this.getOrNull(azContext, "trace-context", Context.class);
        if (traceContext == null && (parentSpan = this.getOrNull(azContext, "parent-span", Span.class)) != null) {
            traceContext = Context.current().with((ImplicitContextKeyed)parentSpan);
        }
        return traceContext == null ? defaultContext : traceContext;
    }

    private Span getSpanOrNull(com.azure.core.util.Context azContext) {
        Span parentSpan;
        Context traceContext = this.getOrNull(azContext, "trace-context", Context.class);
        if (traceContext == null && (parentSpan = this.getOrNull(azContext, "parent-span", Span.class)) != null) {
            return parentSpan;
        }
        return traceContext == null ? null : Span.fromContext((Context)traceContext);
    }
}

