/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry.implementation;

import com.azure.core.util.logging.ClientLogger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import java.lang.reflect.Method;
import java.util.Objects;

public class OpenTelemetrySpanSuppressionHelper {
    private static boolean agentDiscovered;
    private static final ClientLogger LOGGER;
    private static Method getAgentContextMethod;
    private static Method setSpanKeyMethod;
    private static Object clientSpanKey;
    private static Method getAgentSpanMethod;
    private static Method agentContextMakeCurrentMethod;

    public static Object registerClientSpan(Context traceContext) {
        Objects.requireNonNull(traceContext, "'traceContext' cannot be null");
        if (agentDiscovered) {
            try {
                return setSpanKeyMethod.invoke(clientSpanKey, getAgentContextMethod.invoke(null, traceContext), getAgentSpanMethod.invoke(null, Span.fromContext((Context)traceContext)));
            }
            catch (Exception ex) {
                LOGGER.warning("Failed to register client span on OpenTelemetry agent", new Object[]{ex});
                agentDiscovered = false;
            }
        }
        return null;
    }

    public static AutoCloseable makeCurrent(Object agentContext, Context traceContext) {
        Objects.requireNonNull(traceContext, "'traceContext' cannot be null");
        if (agentDiscovered && agentContext != null) {
            try {
                return (AutoCloseable)agentContextMakeCurrentMethod.invoke(agentContext, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.warning("Failed to make OpenTelemetry agent context current", new Object[]{ex});
                agentDiscovered = false;
            }
        }
        return traceContext.makeCurrent();
    }

    static {
        LOGGER = new ClientLogger(OpenTelemetrySpanSuppressionHelper.class);
        agentDiscovered = true;
        try {
            Class<?> agentContextStorageClass = Class.forName("io.opentelemetry.javaagent.instrumentation.opentelemetryapi.context.AgentContextStorage");
            Class<?> agentContextClass = Class.forName("io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context");
            Class<?> spanKeyClass = Class.forName("io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKey");
            Class<?> bridgingClass = Class.forName("io.opentelemetry.javaagent.instrumentation.opentelemetryapi.trace.Bridging");
            Class<?> agentSpanClass = Class.forName("io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span");
            getAgentContextMethod = agentContextStorageClass.getDeclaredMethod("getAgentContext", Context.class);
            getAgentSpanMethod = bridgingClass.getDeclaredMethod("toAgentOrNull", Span.class);
            clientSpanKey = spanKeyClass.getDeclaredField("ALL_CLIENTS").get(null);
            setSpanKeyMethod = spanKeyClass.getDeclaredMethod("storeInContext", agentContextClass, agentSpanClass);
            agentContextMakeCurrentMethod = agentContextClass.getMethod("makeCurrent", new Class[0]);
            if (getAgentContextMethod.getReturnType() != agentContextClass || getAgentSpanMethod.getReturnType() != agentSpanClass || setSpanKeyMethod.getReturnType() != agentContextClass || !AutoCloseable.class.isAssignableFrom(agentContextMakeCurrentMethod.getReturnType())) {
                agentDiscovered = false;
            }
        }
        catch (Exception ex) {
            LOGGER.verbose("Failed to discover OpenTelemetry agent classes, HTTP spans may be duplicated", new Object[]{ex});
            agentDiscovered = false;
        }
    }
}

