/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.AfterRetryPolicyProvider;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.tracing.opentelemetry.implementation.HttpTraceUtil;
import com.azure.core.util.CoreUtils;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Optional;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.util.context.ContextView;

public class OpenTelemetryHttpPolicy
implements AfterRetryPolicyProvider,
HttpPipelinePolicy {
    private final Tracer tracer;
    private static final String HTTP_USER_AGENT = "http.user_agent";
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String SERVICE_REQUEST_ID_HEADER = "x-ms-request-id";
    private static final String SERVICE_REQUEST_ID_ATTRIBUTE = "serviceRequestId";
    private static final String CLIENT_REQUEST_ID_HEADER = "x-ms-client-request-id";
    private static final String CLIENT_REQUEST_ID_ATTRIBUTE = "requestId";
    private static final String REACTOR_PARENT_TRACE_CONTEXT_KEY = "otel-context-key";
    private final TextMapPropagator traceContextFormat = W3CTraceContextPropagator.getInstance();
    private final TextMapSetter<HttpRequest> contextSetter = (request, key, value) -> request.getHeaders().set(key, value);

    public HttpPipelinePolicy create() {
        return this;
    }

    public OpenTelemetryHttpPolicy() {
        this(GlobalOpenTelemetry.getTracer((String)"Azure-OpenTelemetry"));
    }

    OpenTelemetryHttpPolicy(Tracer tracer) {
        this.tracer = tracer;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (context.getData("disable-tracing").orElse(false).booleanValue()) {
            return next.process();
        }
        return ScalarPropagatingMono.INSTANCE.flatMap(ignored -> next.process()).doOnEach(OpenTelemetryHttpPolicy::handleResponse).contextWrite((ContextView)reactor.util.context.Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.startSpan(context)));
    }

    private Context startSpan(HttpPipelineCallContext azContext) {
        Context parentContext = OpenTelemetryHttpPolicy.getTraceContextOrCurrent(azContext);
        HttpRequest request = azContext.getHttpRequest();
        String methodName = request.getHttpMethod().toString();
        Span span = this.tracer.spanBuilder("HTTP " + methodName).setAttribute(HTTP_METHOD, methodName).setAttribute(HTTP_URL, request.getUrl().toString()).setParent(parentContext).setSpanKind(SpanKind.CLIENT).startSpan();
        if (span.isRecording()) {
            OpenTelemetryHttpPolicy.addPostSamplingAttributes(span, request, azContext);
        }
        Context traceContext = parentContext.with((ImplicitContextKeyed)span);
        this.traceContextFormat.inject(traceContext, (Object)request, this.contextSetter);
        return traceContext;
    }

    private static void addPostSamplingAttributes(Span span, HttpRequest request, HttpPipelineCallContext context) {
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, HTTP_USER_AGENT, request.getHeaders().getValue("User-Agent"));
        Optional tracingNamespace = context.getData("az.namespace");
        tracingNamespace.ifPresent(o -> OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, "az.namespace", o.toString()));
        String requestId = request.getHeaders().getValue(CLIENT_REQUEST_ID_HEADER);
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, CLIENT_REQUEST_ID_ATTRIBUTE, requestId);
    }

    private static void putAttributeIfNotEmptyOrNull(Span span, String key, String value) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)value)) {
            span.setAttribute(AttributeKey.stringKey((String)key), (Object)value);
        }
    }

    private static void handleResponse(Signal<? extends HttpResponse> signal) {
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        ContextView context = signal.getContextView();
        Optional traceContext = context.getOrEmpty((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY);
        if (!traceContext.isPresent()) {
            return;
        }
        Span span = Span.fromContext((Context)((Context)traceContext.get()));
        HttpResponse httpResponse = null;
        Throwable error = null;
        if (signal.isOnNext()) {
            httpResponse = (HttpResponse)signal.get();
        } else {
            error = signal.getThrowable();
            if (error instanceof HttpResponseException) {
                HttpResponseException exception = (HttpResponseException)error;
                httpResponse = exception.getResponse();
            }
        }
        OpenTelemetryHttpPolicy.spanEnd(span, httpResponse, error);
    }

    private static void spanEnd(Span span, HttpResponse response, Throwable error) {
        if (span.isRecording()) {
            int statusCode = 0;
            String requestId = null;
            if (response != null) {
                statusCode = response.getStatusCode();
                requestId = response.getHeaderValue(SERVICE_REQUEST_ID_HEADER);
            }
            OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, SERVICE_REQUEST_ID_ATTRIBUTE, requestId);
            span.setAttribute(HTTP_STATUS_CODE, (long)statusCode);
            span = HttpTraceUtil.setSpanStatus(span, statusCode, error);
        }
        span.end();
    }

    private static Context getTraceContextOrCurrent(HttpPipelineCallContext azContext) {
        Optional traceContextOpt = azContext.getData("trace-context");
        if (traceContextOpt.isPresent() && traceContextOpt.get() instanceof Context) {
            return (Context)traceContextOpt.get();
        }
        return Context.current();
    }

    static final class ScalarPropagatingMono
    extends Mono<Object> {
        public static final Mono<Object> INSTANCE = new ScalarPropagatingMono();
        private final Object value = new Object();

        private ScalarPropagatingMono() {
        }

        public void subscribe(CoreSubscriber<? super Object> actual) {
            Context traceContext = (Context)actual.currentContext().getOrDefault((Object)OpenTelemetryHttpPolicy.REACTOR_PARENT_TRACE_CONTEXT_KEY, null);
            if (traceContext != null) {
                try (Scope scope = traceContext.makeCurrent();){
                    actual.onSubscribe(Operators.scalarSubscription(actual, (Object)this.value));
                }
            } else {
                actual.onSubscribe(Operators.scalarSubscription(actual, (Object)this.value));
            }
        }
    }
}

