/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry;

import com.azure.core.tracing.opentelemetry.OpenTelemetrySchemaVersion;
import com.azure.core.util.logging.ClientLogger;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class OpenTelemetryUtils {
    private static final ClientLogger LOGGER = new ClientLogger(OpenTelemetryUtils.class);
    private static final Map<String, String> ATTRIBUTE_MAPPING_V1_17_0 = OpenTelemetryUtils.getMappingsV1200();
    static final String SERVICE_REQUEST_ID_ATTRIBUTE = "serviceRequestId";
    static final String CLIENT_REQUEST_ID_ATTRIBUTE = "requestId";

    OpenTelemetryUtils() {
    }

    private static Map<String, String> getMappingsV1200() {
        HashMap<String, String> mappings = new HashMap<String, String>(8);
        mappings.put("entity-path", "messaging.destination.name");
        mappings.put("hostname", "net.peer.name");
        mappings.put(CLIENT_REQUEST_ID_ATTRIBUTE, "az.client_request_id");
        mappings.put(SERVICE_REQUEST_ID_ATTRIBUTE, "az.service_request_id");
        return Collections.unmodifiableMap(mappings);
    }

    public static Attributes convert(Map<String, Object> attributeMap, OpenTelemetrySchemaVersion schemaVersion) {
        if (attributeMap == null || attributeMap.isEmpty()) {
            return Attributes.empty();
        }
        Map<String, String> mappings = OpenTelemetryUtils.getMappingsForVersion(schemaVersion);
        AttributesBuilder builder = Attributes.builder();
        for (Map.Entry<String, Object> kvp : attributeMap.entrySet()) {
            if (kvp.getValue() == null) continue;
            OpenTelemetryUtils.addAttribute(builder, mappings.getOrDefault(kvp.getKey(), kvp.getKey()), kvp.getValue());
        }
        return builder.build();
    }

    private static Map<String, String> getMappingsForVersion(OpenTelemetrySchemaVersion version) {
        if (version == OpenTelemetrySchemaVersion.V1_17_0) {
            return ATTRIBUTE_MAPPING_V1_17_0;
        }
        LOGGER.verbose("Unknown OpenTelemetry Semantic Conventions version: {}, using latest instead: {}", new Object[]{version, OpenTelemetrySchemaVersion.getLatest()});
        return OpenTelemetryUtils.getMappingsForVersion(OpenTelemetrySchemaVersion.getLatest());
    }

    private static void addAttribute(AttributesBuilder attributesBuilder, String key, Object value) {
        Objects.requireNonNull(key, "OpenTelemetry attribute name cannot be null.");
        if (value instanceof String) {
            attributesBuilder.put(AttributeKey.stringKey((String)key), (Object)((String)value));
        } else if (value instanceof Long) {
            attributesBuilder.put(AttributeKey.longKey((String)key), (Object)((Long)value));
        } else if (value instanceof Integer) {
            attributesBuilder.put(AttributeKey.longKey((String)key), ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            attributesBuilder.put(AttributeKey.booleanKey((String)key), (Object)((Boolean)value));
        } else if (value instanceof Double) {
            attributesBuilder.put(AttributeKey.doubleKey((String)key), (Object)((Double)value));
        } else if (value instanceof Float) {
            attributesBuilder.put(AttributeKey.doubleKey((String)key), (Object)((Float)value).doubleValue());
        } else if (value instanceof Short) {
            attributesBuilder.put(AttributeKey.longKey((String)key), (int)((Short)value).shortValue());
        } else if (value instanceof Byte) {
            attributesBuilder.put(AttributeKey.longKey((String)key), (int)((Byte)value).byteValue());
        } else {
            LOGGER.warning("Could not populate attribute with key '{}', type {} is not supported.", new Object[]{key, value.getClass().getName()});
        }
    }

    static void addAttribute(Span span, String key, Object value, OpenTelemetrySchemaVersion schemaVersion) {
        Objects.requireNonNull(key, "OpenTelemetry attribute name cannot be null.");
        key = OpenTelemetryUtils.getMappingsForVersion(schemaVersion).getOrDefault(key, key);
        if (value instanceof String) {
            span.setAttribute(AttributeKey.stringKey((String)key), (Object)((String)value));
        } else if (value instanceof Long) {
            span.setAttribute(AttributeKey.longKey((String)key), (Object)((Long)value));
        } else if (value instanceof Integer) {
            span.setAttribute(AttributeKey.longKey((String)key), ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            span.setAttribute(AttributeKey.booleanKey((String)key), (Object)((Boolean)value));
        } else if (value instanceof Double) {
            span.setAttribute(AttributeKey.doubleKey((String)key), (Object)((Double)value));
        } else if (value instanceof Float) {
            span.setAttribute(AttributeKey.doubleKey((String)key), (Object)((Float)value).doubleValue());
        } else if (value instanceof Short) {
            span.setAttribute(AttributeKey.longKey((String)key), (int)((Short)value).shortValue());
        } else if (value instanceof Byte) {
            span.setAttribute(AttributeKey.longKey((String)key), (int)((Byte)value).byteValue());
        } else {
            LOGGER.warning("Could not populate attribute with key '{}', type {} is not supported.", new Object[]{key, value.getClass().getName()});
        }
    }

    public static Span setError(Span span, String statusMessage, Throwable throwable) {
        if (throwable != null) {
            span.recordException(throwable);
            return span.setStatus(StatusCode.ERROR, statusMessage);
        }
        if (statusMessage != null) {
            if ("error".equals(statusMessage)) {
                return span.setStatus(StatusCode.ERROR);
            }
            return span.setStatus(StatusCode.ERROR, statusMessage);
        }
        return span;
    }
}

