/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry;

import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import reactor.core.Exceptions;

final class ExceptionUtils {
    private static final Class<?> COMPLETION_EXCEPTION_CLASS;

    public static Throwable unwrapError(Throwable error) {
        if ((error = Exceptions.unwrap((Throwable)error)) != null && error.getCause() != null && (error instanceof UncheckedIOException || error instanceof ExecutionException || ExceptionUtils.isInstanceOfCompletionException(error) || error instanceof InvocationTargetException || error instanceof UndeclaredThrowableException)) {
            return ExceptionUtils.unwrapError(error.getCause());
        }
        return error;
    }

    private static boolean isInstanceOfCompletionException(Throwable error) {
        return COMPLETION_EXCEPTION_CLASS != null && COMPLETION_EXCEPTION_CLASS.isInstance(error);
    }

    private ExceptionUtils() {
    }

    static {
        Class<?> completionExceptionClass = null;
        try {
            completionExceptionClass = Class.forName("java.util.concurrent.CompletionException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        COMPLETION_EXCEPTION_CLASS = completionExceptionClass;
    }
}

