/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry;

import com.azure.core.tracing.opentelemetry.OpenTelemetryTracingOptions;
import com.azure.core.tracing.opentelemetry.OpenTelemetryUtils;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.TracingLink;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class OpenTelemetryTracer
implements com.azure.core.util.tracing.Tracer {
    private static final StartSpanOptions DEFAULT_SPAN_START_OPTIONS = new StartSpanOptions(SpanKind.INTERNAL);
    private static final TextMapPropagator TRACE_CONTEXT_FORMAT = W3CTraceContextPropagator.getInstance();
    private static final String SCHEMA_URL = "https://opentelemetry.io/schemas/1.23.1";
    private static final ClientLogger LOGGER = new ClientLogger(OpenTelemetryTracer.class);
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final String SUPPRESSED_SPAN_FLAG = "suppressed-span-flag";
    private static final String CLIENT_METHOD_CALL_FLAG = "client-method-call-flag";
    private static final String AZ_TRACING_NAMESPACE_KEY = "az.namespace";
    private final Tracer tracer;
    private final boolean isEnabled;
    private final String azNamespace;

    public OpenTelemetryTracer() {
        this("azure-core", null, null, null);
    }

    OpenTelemetryTracer(String libraryName, String libraryVersion, String azNamespace, TracingOptions options) {
        TracerProvider otelProvider = OpenTelemetryTracer.getTracerProvider(options);
        this.isEnabled = (options == null || options.isEnabled()) && otelProvider != TracerProvider.noop();
        this.azNamespace = azNamespace;
        this.tracer = otelProvider.tracerBuilder(libraryName).setInstrumentationVersion(libraryVersion).setSchemaUrl(SCHEMA_URL).build();
    }

    public com.azure.core.util.Context start(String spanName, com.azure.core.util.Context context) {
        return this.start(spanName, DEFAULT_SPAN_START_OPTIONS, context);
    }

    public com.azure.core.util.Context start(String spanName, StartSpanOptions options, com.azure.core.util.Context context) {
        String tracingNamespace;
        Span span;
        Objects.requireNonNull(spanName, "'spanName' cannot be null.");
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (!this.isEnabled) {
            return context;
        }
        io.opentelemetry.api.trace.SpanKind spanKind = this.convertToOtelKind(options.getSpanKind());
        if (OpenTelemetryTracer.shouldSuppress(spanKind, context)) {
            return this.startSuppressedSpan(context);
        }
        context = OpenTelemetryTracer.unsuppress(context);
        if (OpenTelemetryTracer.isInternalOrClientSpan(spanKind) && !context.getData((Object)CLIENT_METHOD_CALL_FLAG).isPresent()) {
            context = context.addData((Object)CLIENT_METHOD_CALL_FLAG, (Object)true);
        }
        Context traceContext = OpenTelemetryTracer.getTraceContextOrDefault(context, null);
        SpanBuilder spanBuilder = this.createSpanBuilder(spanName, options, traceContext);
        if (options.getStartTimestamp() != null) {
            spanBuilder.setStartTimestamp(options.getStartTimestamp());
        }
        if ((span = spanBuilder.startSpan()).isRecording() && (tracingNamespace = this.getAzNamespace(context)) != null) {
            OpenTelemetryUtils.addAttribute(span, AZ_TRACING_NAMESPACE_KEY, (Object)tracingNamespace);
        }
        return context.addData((Object)"trace-context", (Object)(traceContext != null ? traceContext : Context.current()).with((ImplicitContextKeyed)span));
    }

    private io.opentelemetry.api.trace.SpanKind convertToOtelKind(SpanKind kind) {
        switch (kind) {
            case CLIENT: {
                return io.opentelemetry.api.trace.SpanKind.CLIENT;
            }
            case SERVER: {
                return io.opentelemetry.api.trace.SpanKind.SERVER;
            }
            case CONSUMER: {
                return io.opentelemetry.api.trace.SpanKind.CONSUMER;
            }
            case PRODUCER: {
                return io.opentelemetry.api.trace.SpanKind.PRODUCER;
            }
        }
        return io.opentelemetry.api.trace.SpanKind.INTERNAL;
    }

    private SpanBuilder createSpanBuilder(String spanName, StartSpanOptions options, Context parentContext) {
        SpanContext remoteSpanContext;
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName).setSpanKind(this.convertToOtelKind(options.getSpanKind()));
        com.azure.core.util.Context remoteParentContext = options.getRemoteParent();
        SpanContext spanContext = remoteSpanContext = remoteParentContext == null ? null : OpenTelemetryTracer.getOrNull(remoteParentContext, "span-context", SpanContext.class);
        if (remoteSpanContext != null) {
            if (parentContext == null) {
                parentContext = Context.root();
            }
            spanBuilder.setParent(parentContext.with((ImplicitContextKeyed)Span.wrap((SpanContext)remoteSpanContext)));
        } else if (parentContext != null) {
            spanBuilder.setParent(parentContext);
        }
        if (options.getAttributes() != null) {
            Attributes beforeSamplingAttributes = OpenTelemetryUtils.convert(options.getAttributes());
            spanBuilder.setAllAttributes(beforeSamplingAttributes);
        }
        if (!CoreUtils.isNullOrEmpty((Collection)options.getLinks())) {
            for (TracingLink link : options.getLinks()) {
                SpanContext spanContext2 = OpenTelemetryTracer.getOrNull(link.getContext(), "span-context", SpanContext.class);
                spanBuilder.addLink(spanContext2 != null ? spanContext2 : SpanContext.getInvalid(), OpenTelemetryUtils.convert(link.getAttributes()));
            }
        }
        return spanBuilder;
    }

    public void injectContext(BiConsumer<String, String> headerSetter, com.azure.core.util.Context context) {
        Context otelContext = OpenTelemetryTracer.getTraceContextOrDefault(context, null);
        if (otelContext != null) {
            TRACE_CONTEXT_FORMAT.inject(otelContext, null, (ignored, key, value) -> headerSetter.accept(key, value));
        }
    }

    public void setAttribute(String key, long value, com.azure.core.util.Context context) {
        Objects.requireNonNull(context, "'context' cannot be null");
        if (!this.isEnabled) {
            return;
        }
        Span span = this.getSpanOrNull(context);
        if (span == null) {
            return;
        }
        if (span.isRecording()) {
            OpenTelemetryUtils.addAttribute(span, key, (Object)value);
        }
    }

    public void setAttribute(String key, String value, com.azure.core.util.Context context) {
        Objects.requireNonNull(context, "'context' cannot be null");
        if (CoreUtils.isNullOrEmpty((CharSequence)value)) {
            LOGGER.verbose("Failed to set span attribute since value is null or empty.");
            return;
        }
        if (!this.isEnabled) {
            return;
        }
        Span span = this.getSpanOrNull(context);
        if (span == null) {
            return;
        }
        if (span.isRecording()) {
            OpenTelemetryUtils.addAttribute(span, key, (Object)value);
        }
    }

    public void setAttribute(String key, Object value, com.azure.core.util.Context context) {
        Objects.requireNonNull(value, "'value' cannot be null");
        Objects.requireNonNull(context, "'context' cannot be null");
        if (!this.isEnabled) {
            return;
        }
        Span span = this.getSpanOrNull(context);
        if (span == null) {
            return;
        }
        if (span.isRecording()) {
            OpenTelemetryUtils.addAttribute(span, key, value);
        }
    }

    public void end(String errorMessage, Throwable throwable, com.azure.core.util.Context context) {
        if (!this.isEnabled) {
            return;
        }
        Span span = this.getSpanOrNull(context);
        if (span != null) {
            span = OpenTelemetryUtils.setError(span, errorMessage, throwable);
            span.end();
        }
    }

    public com.azure.core.util.Context extractContext(Function<String, String> headerGetter) {
        Objects.requireNonNull(headerGetter, "'headerGetter' cannot be null");
        if (!this.isEnabled) {
            return com.azure.core.util.Context.NONE;
        }
        Context traceContext = TRACE_CONTEXT_FORMAT.extract(Context.root(), headerGetter, Getter.INSTANCE);
        return new com.azure.core.util.Context((Object)"span-context", (Object)Span.fromContext((Context)traceContext).getSpanContext());
    }

    public boolean isRecording(com.azure.core.util.Context context) {
        Objects.requireNonNull(context, "'context' cannot be null");
        if (!this.isEnabled) {
            return false;
        }
        Span span = this.getSpanOrNull(context);
        if (span != null) {
            return span.isRecording();
        }
        return false;
    }

    public AutoCloseable makeSpanCurrent(com.azure.core.util.Context context) {
        if (!this.isEnabled || OpenTelemetryTracer.getBoolean(SUPPRESSED_SPAN_FLAG, context)) {
            return NOOP_CLOSEABLE;
        }
        Context traceContext = OpenTelemetryTracer.getTraceContextOrDefault(context, null);
        if (traceContext == null) {
            return NOOP_CLOSEABLE;
        }
        return traceContext.makeCurrent();
    }

    public void addEvent(String eventName, Map<String, Object> traceEventAttributes, OffsetDateTime timestamp, com.azure.core.util.Context context) {
        Objects.requireNonNull(eventName, "'eventName' cannot be null.");
        if (!this.isEnabled) {
            return;
        }
        Span currentSpan = this.getSpanOrNull(context);
        if (currentSpan == null) {
            LOGGER.verbose("There is no OpenTelemetry Span or Context on the context, cannot add event");
            return;
        }
        Attributes otelAttributes = OpenTelemetryUtils.convert(traceEventAttributes);
        if (timestamp == null) {
            currentSpan.addEvent(eventName, otelAttributes);
        } else {
            currentSpan.addEvent(eventName, otelAttributes, timestamp.toInstant());
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private String getAzNamespace(com.azure.core.util.Context context) {
        return this.azNamespace != null ? this.azNamespace : OpenTelemetryTracer.getOrNull(context, AZ_TRACING_NAMESPACE_KEY, String.class);
    }

    private static <T> T getOrNull(com.azure.core.util.Context context, String key, Class<T> clazz) {
        Object data = context.getData((Object)key).orElse(null);
        if (data != null && clazz.isAssignableFrom(data.getClass())) {
            return (T)data;
        }
        return null;
    }

    private static Context getTraceContextOrDefault(com.azure.core.util.Context azContext, Context defaultContext) {
        Context traceContext = OpenTelemetryTracer.getOrNull(azContext, "trace-context", Context.class);
        return traceContext == null ? defaultContext : traceContext;
    }

    private Span getSpanOrNull(com.azure.core.util.Context azContext) {
        if (OpenTelemetryTracer.getBoolean(SUPPRESSED_SPAN_FLAG, azContext)) {
            return null;
        }
        Context traceContext = OpenTelemetryTracer.getOrNull(azContext, "trace-context", Context.class);
        return traceContext == null ? null : Span.fromContext((Context)traceContext);
    }

    private com.azure.core.util.Context startSuppressedSpan(com.azure.core.util.Context context) {
        return context.addData((Object)SUPPRESSED_SPAN_FLAG, (Object)true);
    }

    private static boolean shouldSuppress(io.opentelemetry.api.trace.SpanKind kind, com.azure.core.util.Context context) {
        return kind == io.opentelemetry.api.trace.SpanKind.INTERNAL && OpenTelemetryTracer.getBoolean(CLIENT_METHOD_CALL_FLAG, context);
    }

    private static com.azure.core.util.Context unsuppress(com.azure.core.util.Context context) {
        if (OpenTelemetryTracer.getBoolean(SUPPRESSED_SPAN_FLAG, context)) {
            return context.addData((Object)SUPPRESSED_SPAN_FLAG, (Object)false);
        }
        return context;
    }

    private static boolean getBoolean(String key, com.azure.core.util.Context context) {
        Optional flag = context.getData((Object)key);
        return flag.isPresent() && Boolean.TRUE.equals(flag.get());
    }

    private static TracerProvider getTracerProvider(TracingOptions options) {
        if (options != null && options.isEnabled() && options instanceof OpenTelemetryTracingOptions && ((OpenTelemetryTracingOptions)options).getOpenTelemetryProvider() != null) {
            return ((OpenTelemetryTracingOptions)options).getOpenTelemetryProvider();
        }
        return GlobalOpenTelemetry.getTracerProvider();
    }

    private static boolean isInternalOrClientSpan(io.opentelemetry.api.trace.SpanKind kind) {
        return kind == io.opentelemetry.api.trace.SpanKind.INTERNAL || kind == io.opentelemetry.api.trace.SpanKind.CLIENT;
    }

    private static class Getter
    implements TextMapGetter<Function<String, String>> {
        public static final TextMapGetter<Function<String, String>> INSTANCE = new Getter();
        private static final Iterable<String> KEYS = Arrays.asList("traceparent", "tracestate");

        private Getter() {
        }

        public Iterable<String> keys(Function<String, String> headerGetter) {
            return KEYS;
        }

        public String get(Function<String, String> headerGetter, String headerName) {
            if (headerGetter == null) {
                return null;
            }
            String value = headerGetter.apply(headerName);
            if ("traceparent".equals(headerName) && value == null) {
                value = headerGetter.apply("Diagnostic-Id");
            }
            return value;
        }
    }
}

