/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry;

import com.azure.core.tracing.opentelemetry.implementation.AmqpPropagationFormatUtil;
import com.azure.core.tracing.opentelemetry.implementation.AmqpTraceUtil;
import com.azure.core.tracing.opentelemetry.implementation.HttpTraceUtil;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OpenTelemetryTracer
implements com.azure.core.util.tracing.Tracer {
    private final Tracer tracer = GlobalOpenTelemetry.getTracer((String)"Azure-OpenTelemetry");
    static final String AZ_NAMESPACE_KEY = "az.namespace";
    static final String MESSAGE_BUS_DESTINATION = "message_bus.destination";
    static final String PEER_ENDPOINT = "peer.address";
    private final ClientLogger logger = new ClientLogger(OpenTelemetryTracer.class);

    public com.azure.core.util.Context start(String spanName, com.azure.core.util.Context context) {
        String tracingNamespace;
        Objects.requireNonNull(spanName, "'spanName' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        SpanBuilder spanBuilder = this.getSpanBuilder(spanName, context);
        Span span = spanBuilder.startSpan();
        if (span.isRecording() && (tracingNamespace = this.getOrDefault(context, AZ_NAMESPACE_KEY, null, String.class)) != null) {
            span.setAttribute(AZ_NAMESPACE_KEY, tracingNamespace);
        }
        return context.addData((Object)"parent-span", (Object)span);
    }

    public com.azure.core.util.Context start(String spanName, com.azure.core.util.Context context, ProcessKind processKind) {
        Objects.requireNonNull(spanName, "'spanName' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(processKind, "'processKind' cannot be null.");
        switch (processKind) {
            case SEND: {
                SpanBuilder spanBuilder = this.getOrDefault(context, "builder", null, SpanBuilder.class);
                if (spanBuilder == null) {
                    return com.azure.core.util.Context.NONE;
                }
                Span span = spanBuilder.setSpanKind(SpanKind.CLIENT).startSpan();
                if (span.isRecording()) {
                    this.addSpanRequestAttributes(span, context, spanName);
                }
                return context.addData((Object)"parent-span", (Object)span);
            }
            case MESSAGE: {
                SpanBuilder spanBuilder = this.getSpanBuilder(spanName, context);
                Span span = spanBuilder.setSpanKind(SpanKind.PRODUCER).startSpan();
                if (span.isRecording()) {
                    this.addSpanRequestAttributes(span, context, spanName);
                }
                context = OpenTelemetryTracer.setContextData(span);
                return context.addData((Object)"parent-span", (Object)span);
            }
            case PROCESS: {
                return this.startScopedSpan(spanName, context);
            }
        }
        return com.azure.core.util.Context.NONE;
    }

    public void end(int responseCode, Throwable throwable, com.azure.core.util.Context context) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        Span span = this.getOrDefault(context, "parent-span", null, Span.class);
        if (span == null) {
            return;
        }
        if (span.isRecording()) {
            span = HttpTraceUtil.setSpanStatus(span, responseCode, throwable);
        }
        span.end();
    }

    public void setAttribute(String key, String value, com.azure.core.util.Context context) {
        Objects.requireNonNull(context, "'context' cannot be null");
        if (CoreUtils.isNullOrEmpty((CharSequence)value)) {
            this.logger.warning("Failed to set span attribute since value is null or empty.");
            return;
        }
        Span span = this.getOrDefault(context, "parent-span", null, Span.class);
        if (span != null) {
            span.setAttribute(key, value);
        } else {
            this.logger.warning("Failed to find span to add attribute.");
        }
    }

    public com.azure.core.util.Context setSpanName(String spanName, com.azure.core.util.Context context) {
        return context.addData((Object)"user-span-name", (Object)spanName);
    }

    public void end(String statusMessage, Throwable throwable, com.azure.core.util.Context context) {
        Span span = this.getOrDefault(context, "parent-span", null, Span.class);
        if (span == null) {
            this.logger.warning("Failed to find span to end it.");
            return;
        }
        if (span.isRecording()) {
            span = AmqpTraceUtil.parseStatusMessage(span, statusMessage, throwable);
        }
        span.end();
    }

    public void addLink(com.azure.core.util.Context context) {
        SpanBuilder spanBuilder = this.getOrDefault(context, "builder", null, SpanBuilder.class);
        if (spanBuilder == null) {
            this.logger.warning("Failed to find spanBuilder to link it.");
            return;
        }
        SpanContext spanContext = this.getOrDefault(context, "span-context", null, SpanContext.class);
        if (spanContext == null) {
            this.logger.warning("Failed to find span context to link it.");
            return;
        }
        spanBuilder.addLink(spanContext);
    }

    public com.azure.core.util.Context extractContext(String diagnosticId, com.azure.core.util.Context context) {
        return AmqpPropagationFormatUtil.extractContext(diagnosticId, context);
    }

    public com.azure.core.util.Context getSharedSpanBuilder(String spanName, com.azure.core.util.Context context) {
        return context.addData((Object)"builder", (Object)this.getSpanBuilder(spanName, context));
    }

    public void addEvent(String eventName, Map<String, Object> traceEventAttributes, OffsetDateTime timestamp) {
        Objects.requireNonNull(eventName, "'eventName' cannot be null.");
        Span currentSpan = Span.current();
        if (currentSpan == null) {
            this.logger.info("Failed to find a starting span to associate the %s with.", new Object[]{eventName});
            return;
        }
        if (timestamp == null) {
            currentSpan.addEvent(eventName, traceEventAttributes == null ? Attributes.empty() : this.convertToOtelAttributes(traceEventAttributes));
        } else {
            currentSpan.addEvent(eventName, traceEventAttributes == null ? Attributes.empty() : this.convertToOtelAttributes(traceEventAttributes), timestamp.toInstant());
        }
    }

    private Attributes convertToOtelAttributes(Map<String, Object> attributes) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((key, value) -> {
            if (value instanceof Boolean) {
                attributesBuilder.put(key, ((Boolean)value).booleanValue());
            } else if (value instanceof String) {
                attributesBuilder.put(key, String.valueOf(value));
            } else if (value instanceof Double) {
                attributesBuilder.put(key, ((Double)value).doubleValue());
            } else if (value instanceof Long) {
                attributesBuilder.put(key, ((Long)value).longValue());
            } else if (value instanceof String[]) {
                attributesBuilder.put(key, (String[])value);
            } else if (value instanceof long[]) {
                attributesBuilder.put(key, (long[])value);
            } else if (value instanceof double[]) {
                attributesBuilder.put(key, (double[])value);
            } else if (value instanceof boolean[]) {
                attributesBuilder.put(key, (boolean[])value);
            }
        });
        return attributesBuilder.build();
    }

    private com.azure.core.util.Context startScopedSpan(String spanName, com.azure.core.util.Context context) {
        Span span;
        Objects.requireNonNull(context, "'context' cannot be null.");
        SpanContext spanContext = this.getOrDefault(context, "span-context", null, SpanContext.class);
        if (spanContext != null) {
            span = this.startSpanWithRemoteParent(spanName, spanContext);
        } else {
            SpanBuilder spanBuilder = this.getSpanBuilder(spanName, context);
            span = spanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        }
        if (span.isRecording()) {
            this.addSpanRequestAttributes(span, context, spanName);
        }
        return context.addData((Object)"parent-span", (Object)span).addData((Object)"scope", (Object)span.makeCurrent());
    }

    private Span startSpanWithRemoteParent(String spanName, SpanContext spanContext) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName).setParent(Context.root().with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext)));
        spanBuilder.setSpanKind(SpanKind.CONSUMER);
        return spanBuilder.startSpan();
    }

    private static com.azure.core.util.Context setContextData(Span span) {
        SpanContext spanContext = span.getSpanContext();
        String traceparent = AmqpPropagationFormatUtil.getDiagnosticId(spanContext);
        if (traceparent == null) {
            return com.azure.core.util.Context.NONE;
        }
        return new com.azure.core.util.Context((Object)"diagnostic-id", (Object)traceparent).addData((Object)"span-context", (Object)spanContext);
    }

    private void addSpanRequestAttributes(Span span, com.azure.core.util.Context context, String spanName) {
        String tracingNamespace;
        Long messageEnqueuedTime;
        String hostName;
        Objects.requireNonNull(span, "'span' cannot be null.");
        String entityPath = this.getOrDefault(context, "entity-path", null, String.class);
        if (entityPath != null) {
            span.setAttribute(MESSAGE_BUS_DESTINATION, entityPath);
        }
        if ((hostName = this.getOrDefault(context, "hostname", null, String.class)) != null) {
            span.setAttribute(PEER_ENDPOINT, hostName);
        }
        if ((messageEnqueuedTime = this.getOrDefault(context, "x-opt-enqueued-time", null, Long.class)) != null) {
            span.setAttribute("x-opt-enqueued-time", messageEnqueuedTime.longValue());
        }
        if ((tracingNamespace = this.getOrDefault(context, AZ_NAMESPACE_KEY, null, String.class)) != null) {
            span.setAttribute(AZ_NAMESPACE_KEY, tracingNamespace);
        }
    }

    private SpanBuilder getSpanBuilder(String spanName, com.azure.core.util.Context context) {
        Span parentSpan = this.getOrDefault(context, "parent-span", null, Span.class);
        String spanNameKey = this.getOrDefault(context, "user-span-name", null, String.class);
        if (spanNameKey == null) {
            spanNameKey = spanName;
        }
        if (parentSpan == null) {
            parentSpan = Span.current();
        }
        return this.tracer.spanBuilder(spanNameKey).setParent(Context.current().with((ImplicitContextKeyed)parentSpan));
    }

    private <T> T getOrDefault(com.azure.core.util.Context context, String key, T defaultValue, Class<T> clazz) {
        Optional optional = context.getData((Object)key);
        Object result = optional.filter(value -> clazz.isAssignableFrom(value.getClass())).orElseGet(() -> {
            this.logger.verbose("Could not extract key '{}' of type '{}' from context.", new Object[]{key, clazz});
            return defaultValue;
        });
        return (T)result;
    }
}

