/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.tracing.opentelemetry.implementation;

import com.azure.core.util.Context;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import java.util.Objects;

public final class AmqpPropagationFormatUtil {
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;

    private AmqpPropagationFormatUtil() {
    }

    public static Context extractContext(String diagnosticId, Context context) {
        return context.addData((Object)"span-context", (Object)AmqpPropagationFormatUtil.fromDiagnosticId(diagnosticId));
    }

    public static String getDiagnosticId(SpanContext spanContext) {
        Objects.requireNonNull(spanContext, "'spanContext' cannot be null.");
        if (!spanContext.isValid()) {
            return null;
        }
        char[] chars = new char[TRACEPARENT_HEADER_SIZE];
        chars[0] = VERSION.charAt(0);
        chars[1] = VERSION.charAt(1);
        chars[2] = 45;
        String traceId = spanContext.getTraceId();
        for (int i = 0; i < traceId.length(); ++i) {
            chars[3 + i] = traceId.charAt(i);
        }
        chars[AmqpPropagationFormatUtil.SPAN_ID_OFFSET - 1] = 45;
        String spanId = spanContext.getSpanId();
        for (int i = 0; i < spanId.length(); ++i) {
            chars[AmqpPropagationFormatUtil.SPAN_ID_OFFSET + i] = spanId.charAt(i);
        }
        chars[AmqpPropagationFormatUtil.TRACE_OPTION_OFFSET - 1] = 45;
        String traceFlagsHex = spanContext.getTraceFlags().asHex();
        chars[AmqpPropagationFormatUtil.TRACE_OPTION_OFFSET] = traceFlagsHex.charAt(0);
        chars[AmqpPropagationFormatUtil.TRACE_OPTION_OFFSET + 1] = traceFlagsHex.charAt(1);
        return new String(chars, 0, TRACEPARENT_HEADER_SIZE);
    }

    private static SpanContext fromDiagnosticId(String traceparent) {
        if (traceparent == null || traceparent.length() < 55 || !traceparent.startsWith(VERSION)) {
            return SpanContext.create((String)TraceId.getInvalid(), (String)SpanId.getInvalid(), (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault());
        }
        String traceId = traceparent.substring(3, 3 + TraceId.getLength());
        String spanId = traceparent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getLength());
        TraceFlags traceFlags = TraceFlags.fromHex((CharSequence)traceparent, (int)TRACE_OPTION_OFFSET);
        return SpanContext.create((String)traceId, (String)spanId, (TraceFlags)traceFlags, (TraceState)TraceState.builder().build());
    }
}

