/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeader;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class HttpHeaders
implements Iterable<HttpHeader>,
JsonSerializable {
    private final Map<String, HttpHeader> headers = new HashMap<String, HttpHeader>();

    public HttpHeaders() {
    }

    public HttpHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.put(header.getKey(), header.getValue());
        }
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        this();
        for (HttpHeader header : headers) {
            this.put(header.name(), header.value());
        }
    }

    public int size() {
        return this.headers.size();
    }

    public HttpHeaders put(String name, String value) {
        this.headers.put(this.formatKey(name), new HttpHeader(name, value));
        return this;
    }

    public HttpHeader get(String name) {
        return this.headers.get(this.formatKey(name));
    }

    public String value(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.value();
    }

    public String[] values(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.values();
    }

    private String formatKey(String key) {
        return key.toLowerCase(Locale.ROOT);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (HttpHeader header : this.headers.values()) {
            result.put(header.name(), header.value());
        }
        return result;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.headers.values().iterator();
    }

    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(this.toMap());
    }

    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(jsonGenerator, serializerProvider);
    }
}

