/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlBuilder;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HostPolicy
implements HttpPipelinePolicy {
    private final String host;
    private static final Logger LOGGER = LoggerFactory.getLogger(HostPolicy.class);

    public HostPolicy(String host) {
        this.host = host;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Mono<HttpResponse> result;
        LOGGER.info("Setting host to {}", (Object)this.host);
        UrlBuilder urlBuilder = UrlBuilder.parse(context.httpRequest().url());
        try {
            context.httpRequest().url(urlBuilder.host(this.host).toURL());
            result = next.process();
        }
        catch (MalformedURLException e) {
            result = Mono.error((Throwable)e);
        }
        return result;
    }
}

