/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlBuilder;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ProtocolPolicy
implements HttpPipelinePolicy {
    private final String protocol;
    private final boolean overwrite;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolPolicy.class);

    public ProtocolPolicy(String protocol, boolean overwrite) {
        this.protocol = protocol;
        this.overwrite = overwrite;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        UrlBuilder urlBuilder = UrlBuilder.parse(context.httpRequest().url());
        if (this.overwrite || urlBuilder.scheme() == null) {
            LOGGER.info("Setting protocol to {}", (Object)this.protocol);
            try {
                context.httpRequest().url(urlBuilder.scheme(this.protocol).toURL());
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        }
        return next.process();
    }
}

