/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.configuration;

import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.util.configuration.BaseConfigurations;
import com.azure.core.util.configuration.NoopConfiguration;
import com.azure.core.util.logging.ClientLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Configuration
implements Cloneable {
    public static final Configuration NONE = new NoopConfiguration();
    private static final String LOADED_FROM_RUNTIME = "Loaded {} from runtime parameters with value {}.";
    private static final String LOADED_FROM_ENVIRONMENT = "Loaded {} from environment variables with value {}.";
    private final ClientLogger logger = new ClientLogger(Configuration.class);
    private ConcurrentMap<String, String> configurations = new ConcurrentHashMap<String, String>();
    private boolean loadedBaseConfigurations = false;

    public Configuration() {
    }

    private Configuration(ConcurrentMap<String, String> configurations) {
        this.configurations = new ConcurrentHashMap<String, String>(configurations);
    }

    public String get(String name) {
        return this.getOrLoad(name);
    }

    public <T> T get(String name, T defaultValue) {
        return this.convertOrDefault(this.getOrLoad(name), defaultValue);
    }

    public <T> T get(String name, Function<String, T> converter) {
        String value = this.getOrLoad(name);
        if (ImplUtils.isNullOrEmpty(value)) {
            return null;
        }
        return converter.apply(value);
    }

    private String getOrLoad(String name) {
        this.loadBaseConfigurations();
        if ("AZURE_TRACING_DISABLED".equalsIgnoreCase(name) || "AZURE_LOG_LEVEL".equalsIgnoreCase(name)) {
            this.load(name);
        }
        if (this.configurations.containsKey(name)) {
            return (String)this.configurations.get(name);
        }
        return this.load(name);
    }

    private String load(String name) {
        if (this.loadFrom(name, System::getProperty, LOADED_FROM_RUNTIME) || this.loadFrom(name, System::getenv, LOADED_FROM_ENVIRONMENT)) {
            return (String)this.configurations.get(name);
        }
        return null;
    }

    public Configuration put(String name, String value) {
        this.configurations.put(name, value);
        return this;
    }

    public String remove(String name) {
        return (String)this.configurations.remove(name);
    }

    public boolean contains(String name) {
        return this.configurations.containsKey(name);
    }

    public Configuration clone() {
        this.loadBaseConfigurations();
        Configuration clone = new Configuration(this.configurations);
        clone.loadedBaseConfigurations = true;
        return clone;
    }

    private <T> T convertOrDefault(String value, T defaultValue) {
        if (ImplUtils.isNullOrEmpty(value)) {
            return defaultValue;
        }
        Object convertedValue = defaultValue instanceof Byte ? Byte.valueOf(Byte.parseByte(value)) : (defaultValue instanceof Short ? Short.valueOf(Short.parseShort(value)) : (defaultValue instanceof Integer ? Integer.valueOf(Integer.parseInt(value)) : (defaultValue instanceof Long ? Long.valueOf(Long.parseLong(value)) : (defaultValue instanceof Float ? Float.valueOf(Float.parseFloat(value)) : (defaultValue instanceof Double ? Double.valueOf(Double.parseDouble(value)) : (defaultValue instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(value)) : value))))));
        return (T)convertedValue;
    }

    private boolean loadFrom(String name, Function<String, String> loader, String logMessage) {
        String value = loader.apply(name);
        if (!ImplUtils.isNullOrEmpty(value) && !value.equals(this.configurations.get(name))) {
            this.configurations.put(name, value);
            this.logger.asInfo().log(logMessage, name, value);
            return true;
        }
        return false;
    }

    private void loadBaseConfigurations() {
        if (this.loadedBaseConfigurations) {
            return;
        }
        for (String config : BaseConfigurations.DEFAULT_CONFIGURATIONS) {
            if (this.configurations.containsKey(config)) continue;
            this.load(config);
        }
        this.loadedBaseConfigurations = true;
    }
}

