/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;

public final class PollResponse<T> {
    private final OperationStatus status;
    private final T value;
    private final Duration retryAfter;
    private final Map<Object, Object> properties;
    private final String otherStatus;

    public PollResponse(OperationStatus status, T value, Duration retryAfter, Map<Object, Object> properties) {
        this(status, null, value, retryAfter, properties);
    }

    private PollResponse(OperationStatus status, String otherStatus, T value, Duration retryAfter, Map<Object, Object> properties) {
        Objects.requireNonNull(status, "The status input parameter cannot be null.");
        this.status = status;
        this.value = value;
        this.retryAfter = retryAfter;
        this.properties = properties;
        this.otherStatus = otherStatus;
    }

    public PollResponse(OperationStatus status, T value, Duration retryAfter) {
        this(status, value, retryAfter, null);
    }

    public PollResponse(OperationStatus status, T value) {
        this(status, value, null);
    }

    public PollResponse(String otherStatus, T value, Duration retryAfter) {
        this(OperationStatus.OTHER, otherStatus, value, retryAfter, null);
        if (Objects.isNull(otherStatus) || otherStatus.trim().length() == 0) {
            throw new IllegalArgumentException("The otherStatus can not be empty or null.");
        }
    }

    public PollResponse(String otherStatus, T value) {
        this(otherStatus, value, null);
    }

    public String getOtherStatus() {
        return this.otherStatus;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public T getValue() {
        return this.value;
    }

    public Duration getRetryAfter() {
        return this.retryAfter;
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public static enum OperationStatus {
        NOT_STARTED,
        IN_PROGRESS,
        SUCCESSFULLY_COMPLETED,
        FAILED,
        USER_CANCELLED,
        OTHER;

    }
}

