/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.util.polling.PollResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Poller<T> {
    private final Function<PollResponse<T>, Mono<PollResponse<T>>> pollOperation;
    private Duration pollInterval;
    private PollResponse<T> pollResponse;
    private Consumer<Poller> cancelOperation;
    private boolean autoPollingEnabled;
    private Flux<PollResponse<T>> fluxHandle;
    private Disposable fluxDisposable;

    public Poller(Duration pollInterval, Function<PollResponse<T>, Mono<PollResponse<T>>> pollOperation) {
        Objects.requireNonNull(pollInterval, "The poll interval input parameter cannot be null.");
        if (pollInterval.toNanos() <= 0L) {
            throw new IllegalArgumentException("Negative or zero value for poll interval not allowed.");
        }
        Objects.requireNonNull(pollOperation, "The poll operation input parameter cannot be null.");
        this.pollInterval = pollInterval;
        this.pollOperation = pollOperation;
        this.pollResponse = new PollResponse<Object>(PollResponse.OperationStatus.NOT_STARTED, null);
        this.fluxHandle = this.asyncPollRequestWithDelay().flux().repeat().takeUntil(pollResponse -> this.hasCompleted()).share();
        this.fluxDisposable = this.fluxHandle.subscribe();
        this.autoPollingEnabled = true;
    }

    public Poller(Duration pollInterval, Function<PollResponse<T>, Mono<PollResponse<T>>> pollOperation, Consumer<Poller> cancelOperation) {
        this(pollInterval, pollOperation);
        this.cancelOperation = cancelOperation;
    }

    public void cancelOperation() throws UnsupportedOperationException {
        if (this.cancelOperation == null) {
            throw new UnsupportedOperationException("Cancel operation is not supported on this service/resource.");
        }
        if (this.pollResponse != null && this.pollResponse.getStatus() != PollResponse.OperationStatus.IN_PROGRESS) {
            return;
        }
        this.cancelOperation.accept(this);
    }

    public Flux<PollResponse<T>> getObserver() {
        return this.fluxHandle;
    }

    public Mono<PollResponse<T>> poll() {
        return this.pollOperation.apply(this.pollResponse).doOnEach(pollResponseSignal -> {
            if (pollResponseSignal.get() != null) {
                this.pollResponse = (PollResponse)pollResponseSignal.get();
            }
        });
    }

    public PollResponse<T> block() {
        if (!this.isAutoPollingEnabled()) {
            this.setAutoPollingEnabled(true);
        }
        return (PollResponse)this.fluxHandle.blockLast();
    }

    private Mono<PollResponse<T>> asyncPollRequestWithDelay() {
        return Mono.defer(() -> this.pollOperation.apply(this.pollResponse).delaySubscription(this.getCurrentDelay()).onErrorResume(throwable -> Mono.empty()).doOnEach(pollResponseSignal -> {
            if (pollResponseSignal.get() != null) {
                this.pollResponse = (PollResponse)pollResponseSignal.get();
            }
        }));
    }

    private Duration getCurrentDelay() {
        return this.pollResponse != null && this.pollResponse.getRetryAfter() != null && this.pollResponse.getRetryAfter().toNanos() > 0L ? this.pollResponse.getRetryAfter() : this.pollInterval;
    }

    public final void setAutoPollingEnabled(boolean autoPollingEnabled) {
        this.autoPollingEnabled = autoPollingEnabled;
        if (this.autoPollingEnabled) {
            if (!this.activeSubscriber()) {
                this.fluxDisposable = this.fluxHandle.subscribe(pr -> {
                    this.pollResponse = pr;
                });
            }
        } else if (this.activeSubscriber()) {
            this.fluxDisposable.dispose();
        }
    }

    private boolean hasCompleted() {
        return this.pollResponse != null && (this.pollResponse.getStatus() == PollResponse.OperationStatus.SUCCESSFULLY_COMPLETED || this.pollResponse.getStatus() == PollResponse.OperationStatus.FAILED || this.pollResponse.getStatus() == PollResponse.OperationStatus.USER_CANCELLED);
    }

    private boolean activeSubscriber() {
        return this.fluxDisposable != null && !this.fluxDisposable.isDisposed();
    }

    public boolean isAutoPollingEnabled() {
        return this.autoPollingEnabled;
    }

    public PollResponse.OperationStatus getStatus() {
        return this.pollResponse != null ? this.pollResponse.getStatus() : null;
    }
}

