/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credentials;

import com.azure.core.credentials.AccessToken;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;

public class SimpleTokenCache {
    private static final int REFRESH_TIMEOUT_SECONDS = 30;
    private final AtomicBoolean wip;
    private AccessToken cache;
    private final ReplayProcessor<AccessToken> emitterProcessor = ReplayProcessor.create((int)1);
    private final FluxSink<AccessToken> sink = this.emitterProcessor.sink(FluxSink.OverflowStrategy.BUFFER);
    private final Supplier<Mono<AccessToken>> getNew;

    public SimpleTokenCache(Supplier<Mono<AccessToken>> getNew) {
        this.wip = new AtomicBoolean(false);
        this.getNew = getNew;
    }

    public Mono<AccessToken> getToken() {
        if (this.cache != null && !this.cache.isExpired()) {
            return Mono.just((Object)this.cache);
        }
        return Mono.defer(() -> {
            if (!this.wip.getAndSet(true)) {
                return this.getNew.get().doOnNext(ac -> {
                    this.cache = ac;
                }).doOnNext(arg_0 -> this.sink.next(arg_0)).doOnError(arg_0 -> this.sink.error(arg_0)).doOnTerminate(() -> this.wip.set(false));
            }
            return this.emitterProcessor.next();
        });
    }
}

