/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.util.Base64Util;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

public class ProxyAuthenticationPolicy
implements HttpPipelinePolicy {
    private final String username;
    private final String password;

    public ProxyAuthenticationPolicy(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String auth = this.username + ":" + this.password;
        String encodedAuth = Base64Util.encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        context.httpRequest().header("Proxy-Authentication", "Basic " + encodedAuth);
        return next.process();
    }
}

