/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.util.Base64Util;
import com.azure.core.implementation.util.ImplUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class Base64Url {
    private final byte[] bytes;

    public Base64Url(String string) {
        if (string == null) {
            this.bytes = null;
        } else {
            string = Base64Url.unquote(string);
            this.bytes = string.getBytes(StandardCharsets.UTF_8);
        }
    }

    public Base64Url(byte[] bytes) {
        this.bytes = Base64Url.unquote(bytes);
    }

    private static byte[] unquote(byte[] bytes) {
        if (bytes != null && bytes.length > 1) {
            bytes = Base64Url.unquote(new String(bytes, StandardCharsets.UTF_8)).getBytes(StandardCharsets.UTF_8);
        }
        return bytes;
    }

    private static String unquote(String string) {
        int base64UrlStringLength;
        char lastCharacter;
        char firstCharacter;
        if (!(string == null || string.isEmpty() || (firstCharacter = string.charAt(0)) != '\"' && firstCharacter != '\'' || (lastCharacter = string.charAt((base64UrlStringLength = string.length()) - 1)) != firstCharacter)) {
            string = string.substring(1, base64UrlStringLength - 1);
        }
        return string;
    }

    public static Base64Url encode(byte[] bytes) {
        if (bytes == null) {
            return new Base64Url((String)null);
        }
        return new Base64Url(Base64Util.encodeURLWithoutPadding(bytes));
    }

    public byte[] encodedBytes() {
        return ImplUtils.clone(this.bytes);
    }

    public byte[] decodedBytes() {
        if (this.bytes == null) {
            return null;
        }
        byte[] decodedBytes = Base64Util.decodeURL(this.bytes);
        return decodedBytes;
    }

    public String toString() {
        return this.bytes == null ? "" : new String(this.bytes, StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Base64Url)) {
            return false;
        }
        Base64Url rhs = (Base64Url)obj;
        return Arrays.equals(this.bytes, rhs.encodedBytes());
    }
}

