/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.http.HttpRequest;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;

public class OperationDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Serializable pollStrategyData;
    private Map<String, String> headers;
    private String httpMethod;
    private URL url;
    private String fullyQualifiedMethodName;

    public OperationDescription() {
        this.fullyQualifiedMethodName = null;
        this.pollStrategyData = null;
        this.headers = null;
        this.url = null;
        this.httpMethod = null;
    }

    public OperationDescription(String fullyQualifiedMethodName, Serializable pollStrategyData, HttpRequest originalHttpRequest) {
        this.fullyQualifiedMethodName = fullyQualifiedMethodName;
        this.pollStrategyData = pollStrategyData;
        this.headers = originalHttpRequest.headers().toMap();
        this.url = originalHttpRequest.url();
        this.httpMethod = originalHttpRequest.httpMethod().toString();
    }

    public Serializable pollStrategyData() {
        return this.pollStrategyData;
    }

    public URL url() {
        return this.url;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    String methodName() {
        int lastIndex = this.fullyQualifiedMethodName.lastIndexOf(".");
        return this.fullyQualifiedMethodName.substring(lastIndex + 1);
    }
}

