/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.annotations.BodyParam;
import com.azure.core.annotations.DELETE;
import com.azure.core.annotations.ExpectedResponses;
import com.azure.core.annotations.FormParam;
import com.azure.core.annotations.GET;
import com.azure.core.annotations.HEAD;
import com.azure.core.annotations.HeaderParam;
import com.azure.core.annotations.Headers;
import com.azure.core.annotations.HostParam;
import com.azure.core.annotations.PATCH;
import com.azure.core.annotations.POST;
import com.azure.core.annotations.PUT;
import com.azure.core.annotations.PathParam;
import com.azure.core.annotations.QueryParam;
import com.azure.core.annotations.ReturnValueWireType;
import com.azure.core.annotations.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.Base64Url;
import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.EncodedParameter;
import com.azure.core.implementation.PercentEscaper;
import com.azure.core.implementation.Substitution;
import com.azure.core.implementation.UnexpectedExceptionInformation;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.UrlEscapers;
import com.azure.core.implementation.exception.MissingRequiredAnnotationException;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.serializer.jackson.JacksonAdapter;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.implementation.util.TypeUtil;
import com.azure.core.util.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SwaggerMethodParser
implements HttpResponseDecodeData {
    private final SerializerAdapter serializer;
    private final String rawHost;
    private final String fullyQualifiedMethodName;
    private HttpMethod httpMethod;
    private String relativePath;
    private final List<Substitution> hostSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> pathSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> querySubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> formSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> headerSubstitutions = new ArrayList<Substitution>();
    private final HttpHeaders headers = new HttpHeaders();
    private Integer bodyContentMethodParameterIndex;
    private String bodyContentType;
    private Type bodyJavaType;
    private int[] expectedStatusCodes;
    private Type returnType;
    private Type returnValueWireType;
    private final UnexpectedResponseExceptionType[] unexpectedResponseExceptionTypes;
    private Map<Integer, UnexpectedExceptionInformation> exceptionMapping;
    private UnexpectedExceptionInformation defaultException;

    SwaggerMethodParser(Method swaggerMethod, String rawHost) {
        ExpectedResponses expectedResponses;
        this.serializer = JacksonAdapter.createDefaultSerializerAdapter();
        this.rawHost = rawHost;
        Class<?> swaggerInterface = swaggerMethod.getDeclaringClass();
        this.fullyQualifiedMethodName = swaggerInterface.getName() + "." + swaggerMethod.getName();
        if (swaggerMethod.isAnnotationPresent(GET.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.GET, swaggerMethod.getAnnotation(GET.class).value());
        } else if (swaggerMethod.isAnnotationPresent(PUT.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.PUT, swaggerMethod.getAnnotation(PUT.class).value());
        } else if (swaggerMethod.isAnnotationPresent(HEAD.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.HEAD, swaggerMethod.getAnnotation(HEAD.class).value());
        } else if (swaggerMethod.isAnnotationPresent(DELETE.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.DELETE, swaggerMethod.getAnnotation(DELETE.class).value());
        } else if (swaggerMethod.isAnnotationPresent(POST.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.POST, swaggerMethod.getAnnotation(POST.class).value());
        } else if (swaggerMethod.isAnnotationPresent(PATCH.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.PATCH, swaggerMethod.getAnnotation(PATCH.class).value());
        } else {
            ArrayList<Class<? extends Annotation>> requiredAnnotationOptions = new ArrayList<Class<? extends Annotation>>();
            requiredAnnotationOptions.add(GET.class);
            requiredAnnotationOptions.add(PUT.class);
            requiredAnnotationOptions.add(HEAD.class);
            requiredAnnotationOptions.add(DELETE.class);
            requiredAnnotationOptions.add(POST.class);
            requiredAnnotationOptions.add(PATCH.class);
            throw new MissingRequiredAnnotationException(requiredAnnotationOptions, swaggerMethod);
        }
        this.returnType = swaggerMethod.getGenericReturnType();
        ReturnValueWireType returnValueWireTypeAnnotation = swaggerMethod.getAnnotation(ReturnValueWireType.class);
        if (returnValueWireTypeAnnotation != null) {
            Class<?> returnValueWireType = returnValueWireTypeAnnotation.value();
            if (returnValueWireType == Base64Url.class || returnValueWireType == UnixTime.class || returnValueWireType == DateTimeRfc1123.class) {
                this.returnValueWireType = returnValueWireType;
            } else if (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, List.class)) {
                this.returnValueWireType = returnValueWireType.getGenericInterfaces()[0];
            } else if (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, Page.class)) {
                this.returnValueWireType = returnValueWireType;
            }
        }
        if (swaggerMethod.isAnnotationPresent(Headers.class)) {
            String[] headers;
            Headers headersAnnotation = swaggerMethod.getAnnotation(Headers.class);
            for (String header : headers = headersAnnotation.value()) {
                String headerValue;
                String headerName;
                int colonIndex = header.indexOf(":");
                if (colonIndex < 0 || (headerName = header.substring(0, colonIndex).trim()).isEmpty() || (headerValue = header.substring(colonIndex + 1).trim()).isEmpty()) continue;
                this.headers.put(headerName, headerValue);
            }
        }
        if ((expectedResponses = swaggerMethod.getAnnotation(ExpectedResponses.class)) != null) {
            this.expectedStatusCodes = expectedResponses.value();
        }
        this.unexpectedResponseExceptionTypes = (UnexpectedResponseExceptionType[])swaggerMethod.getAnnotationsByType(UnexpectedResponseExceptionType.class);
        Annotation[][] allParametersAnnotations = swaggerMethod.getParameterAnnotations();
        for (int parameterIndex = 0; parameterIndex < allParametersAnnotations.length; ++parameterIndex) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = swaggerMethod.getParameterAnnotations()[parameterIndex]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(HostParam.class)) {
                    HostParam hostParamAnnotation = (HostParam)annotation;
                    this.hostSubstitutions.add(new Substitution(hostParamAnnotation.value(), parameterIndex, !hostParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(PathParam.class)) {
                    PathParam pathParamAnnotation = (PathParam)annotation;
                    this.pathSubstitutions.add(new Substitution(pathParamAnnotation.value(), parameterIndex, !pathParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(QueryParam.class)) {
                    QueryParam queryParamAnnotation = (QueryParam)annotation;
                    this.querySubstitutions.add(new Substitution(queryParamAnnotation.value(), parameterIndex, !queryParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(HeaderParam.class)) {
                    HeaderParam headerParamAnnotation = (HeaderParam)annotation;
                    this.headerSubstitutions.add(new Substitution(headerParamAnnotation.value(), parameterIndex, false));
                    continue;
                }
                if (annotationType.equals(BodyParam.class)) {
                    BodyParam bodyParamAnnotation = (BodyParam)annotation;
                    this.bodyContentMethodParameterIndex = parameterIndex;
                    this.bodyContentType = bodyParamAnnotation.value();
                    this.bodyJavaType = swaggerMethod.getGenericParameterTypes()[parameterIndex];
                    continue;
                }
                if (!annotationType.equals(FormParam.class)) continue;
                FormParam formParamAnnotation = (FormParam)annotation;
                this.formSubstitutions.add(new Substitution(formParamAnnotation.value(), parameterIndex, !formParamAnnotation.encoded()));
                this.bodyContentType = "application/x-www-form-urlencoded";
                this.bodyJavaType = String.class;
            }
        }
    }

    public String fullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    @Override
    public int[] expectedStatusCodes() {
        return ImplUtils.clone(this.expectedStatusCodes);
    }

    public String scheme(Object[] swaggerMethodArguments) {
        String substitutedHost = this.applySubstitutions(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, UrlEscapers.PATH_ESCAPER);
        String[] substitutedHostParts = substitutedHost.split("://");
        return substitutedHostParts.length < 1 ? null : substitutedHostParts[0];
    }

    public String host(Object[] swaggerMethodArguments) {
        String substitutedHost = this.applySubstitutions(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, UrlEscapers.PATH_ESCAPER);
        String[] substitutedHostParts = substitutedHost.split("://");
        return substitutedHostParts.length < 2 ? substitutedHost : substitutedHost.split("://")[1];
    }

    public String path(Object[] methodArguments) {
        return this.applySubstitutions(this.relativePath, this.pathSubstitutions, methodArguments, UrlEscapers.PATH_ESCAPER);
    }

    public Iterable<EncodedParameter> encodedQueryParameters(Object[] swaggerMethodArguments) {
        return this.encodeParameters(swaggerMethodArguments, this.querySubstitutions);
    }

    public Iterable<EncodedParameter> encodedFormParameters(Object[] swaggerMethodArguments) {
        return this.encodeParameters(swaggerMethodArguments, this.formSubstitutions);
    }

    private Iterable<EncodedParameter> encodeParameters(Object[] swaggerMethodArguments, List<Substitution> substitutions) {
        if (substitutions == null) {
            return Collections.emptyList();
        }
        ArrayList<EncodedParameter> result = new ArrayList<EncodedParameter>();
        PercentEscaper escaper = UrlEscapers.QUERY_ESCAPER;
        for (Substitution substitution : substitutions) {
            Object methodArgument;
            String parameterValue;
            int parameterIndex = substitution.methodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length || (parameterValue = this.serialize(methodArgument = swaggerMethodArguments[substitution.methodParameterIndex()])) == null) continue;
            if (substitution.shouldEncode() && escaper != null) {
                parameterValue = escaper.escape(parameterValue);
            }
            result.add(new EncodedParameter(substitution.urlParameterName(), parameterValue));
        }
        return result;
    }

    public Iterable<HttpHeader> headers(Object[] swaggerMethodArguments) {
        HttpHeaders result = new HttpHeaders(this.headers);
        if (this.headerSubstitutions != null) {
            for (Substitution headerSubstitution : this.headerSubstitutions) {
                int parameterIndex = headerSubstitution.methodParameterIndex();
                if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
                Object methodArgument = swaggerMethodArguments[headerSubstitution.methodParameterIndex()];
                if (methodArgument instanceof Map) {
                    Map headerCollection = (Map)methodArgument;
                    String headerCollectionPrefix = headerSubstitution.urlParameterName();
                    for (Map.Entry headerCollectionEntry : headerCollection.entrySet()) {
                        String headerName = headerCollectionPrefix + (String)headerCollectionEntry.getKey();
                        String headerValue = this.serialize(headerCollectionEntry.getValue());
                        result.put(headerName, headerValue);
                    }
                    continue;
                }
                String headerName = headerSubstitution.urlParameterName();
                String headerValue = this.serialize(methodArgument);
                result.put(headerName, headerValue);
            }
        }
        return result;
    }

    public Context context(Object[] swaggerMethodArguments) {
        Context context = ImplUtils.findFirstOfType(swaggerMethodArguments, Context.class);
        return context != null ? context : Context.NONE;
    }

    public boolean isExpectedResponseStatusCode(int responseStatusCode, int[] additionalAllowedStatusCodes) {
        boolean result = this.expectedStatusCodes == null ? responseStatusCode < 400 : SwaggerMethodParser.contains(this.expectedStatusCodes, responseStatusCode) || SwaggerMethodParser.contains(additionalAllowedStatusCodes, responseStatusCode);
        return result;
    }

    private static boolean contains(int[] values, int searchValue) {
        boolean result = false;
        if (values != null && values.length > 0) {
            for (int value : values) {
                if (searchValue != value) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public UnexpectedExceptionInformation getUnexpectedException(int code) {
        if (this.exceptionMapping == null) {
            this.exceptionMapping = this.processUnexpectedResponseExceptionTypes();
        }
        return this.exceptionMapping.getOrDefault(code, this.defaultException);
    }

    public Object body(Object[] swaggerMethodArguments) {
        Object result = null;
        if (this.bodyContentMethodParameterIndex != null && swaggerMethodArguments != null && 0 <= this.bodyContentMethodParameterIndex && this.bodyContentMethodParameterIndex < swaggerMethodArguments.length) {
            result = swaggerMethodArguments[this.bodyContentMethodParameterIndex];
        }
        if (this.formSubstitutions != null && !this.formSubstitutions.isEmpty() && swaggerMethodArguments != null) {
            result = this.formSubstitutions.stream().map(s -> this.serializeFormData(s.urlParameterName(), swaggerMethodArguments[s.methodParameterIndex()])).collect(Collectors.joining("&"));
        }
        return result;
    }

    public String bodyContentType() {
        return this.bodyContentType;
    }

    @Override
    public Type returnType() {
        return this.returnType;
    }

    public Type bodyJavaType() {
        return this.bodyJavaType;
    }

    @Override
    public Type returnValueWireType() {
        return this.returnValueWireType;
    }

    public boolean expectsResponseBody() {
        boolean result = true;
        if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Void.class)) {
            result = false;
        } else if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Mono.class) || TypeUtil.isTypeOrSubTypeOf(this.returnType, Flux.class)) {
            ParameterizedType asyncReturnType = (ParameterizedType)this.returnType;
            Type syncReturnType = asyncReturnType.getActualTypeArguments()[0];
            if (TypeUtil.isTypeOrSubTypeOf(syncReturnType, Void.class)) {
                result = false;
            } else if (TypeUtil.isTypeOrSubTypeOf(syncReturnType, Response.class)) {
                result = TypeUtil.restResponseTypeExpectsBody((ParameterizedType)TypeUtil.getSuperType(syncReturnType, Response.class));
            }
        } else if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Response.class)) {
            result = TypeUtil.restResponseTypeExpectsBody((ParameterizedType)this.returnType);
        }
        return result;
    }

    private void setHttpMethodAndRelativePath(HttpMethod httpMethod, String relativePath) {
        this.httpMethod = httpMethod;
        this.relativePath = relativePath;
    }

    private String serialize(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof String ? (String)value : this.serializer.serializeRaw(value);
        }
        return result;
    }

    private String serializeFormData(String key, Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof List ? ((List)value).stream().map(el -> String.format("%s=%s", key, this.serialize(el))).collect(Collectors.joining("&")) : String.format("%s=%s", key, this.serializer.serializeRaw(value));
        }
        return result;
    }

    private String applySubstitutions(String originalValue, Iterable<Substitution> substitutions, Object[] methodArguments, PercentEscaper escaper) {
        String result = originalValue;
        if (methodArguments != null) {
            for (Substitution substitution : substitutions) {
                int substitutionParameterIndex = substitution.methodParameterIndex();
                if (0 > substitutionParameterIndex || substitutionParameterIndex >= methodArguments.length) continue;
                Object methodArgument = methodArguments[substitutionParameterIndex];
                String substitutionValue = this.serialize(methodArgument);
                if (substitutionValue != null && !substitutionValue.isEmpty() && substitution.shouldEncode() && escaper != null) {
                    substitutionValue = escaper.escape(substitutionValue);
                }
                if (substitutionValue == null) continue;
                result = result.replace("{" + substitution.urlParameterName() + "}", substitutionValue);
            }
        }
        return result;
    }

    private Map<Integer, UnexpectedExceptionInformation> processUnexpectedResponseExceptionTypes() {
        HashMap<Integer, UnexpectedExceptionInformation> exceptionHashMap = new HashMap<Integer, UnexpectedExceptionInformation>();
        for (UnexpectedResponseExceptionType exceptionAnnotation : this.unexpectedResponseExceptionTypes) {
            UnexpectedExceptionInformation exception = new UnexpectedExceptionInformation(exceptionAnnotation.value());
            if (exceptionAnnotation.code().length == 0) {
                this.defaultException = exception;
                continue;
            }
            for (int statusCode : exceptionAnnotation.code()) {
                exceptionHashMap.put(statusCode, exception);
            }
        }
        if (this.defaultException == null) {
            this.defaultException = new UnexpectedExceptionInformation(HttpResponseException.class);
        }
        return exceptionHashMap;
    }
}

