/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.exception.HttpResponseException;
import java.lang.reflect.Method;

public class UnexpectedExceptionInformation {
    private static final String EXCEPTION_BODY_METHOD = "value";
    private Class<? extends HttpResponseException> exceptionType;
    private Class<?> exceptionBodyType;

    public UnexpectedExceptionInformation(Class<? extends HttpResponseException> exceptionType) {
        this.exceptionType = exceptionType;
        try {
            Method exceptionBodyMethod = exceptionType.getDeclaredMethod(EXCEPTION_BODY_METHOD, new Class[0]);
            this.exceptionBodyType = exceptionBodyMethod.getReturnType();
        }
        catch (NoSuchMethodException e) {
            this.exceptionBodyType = Object.class;
        }
    }

    public Class<? extends HttpResponseException> exceptionType() {
        return this.exceptionType;
    }

    public Class<?> exceptionBodyType() {
        return this.exceptionBodyType;
    }
}

