/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class UnixTime {
    private final OffsetDateTime dateTime;

    public UnixTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public UnixTime(long unixSeconds) {
        this.dateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(unixSeconds), ZoneOffset.UTC);
    }

    public OffsetDateTime dateTime() {
        if (this.dateTime == null) {
            return null;
        }
        return this.dateTime;
    }

    public String toString() {
        return this.dateTime.toString();
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnixTime)) {
            return false;
        }
        UnixTime rhs = (UnixTime)obj;
        return this.dateTime.equals(rhs.dateTime());
    }
}

