/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import java.util.Optional;

public class Context {
    public static final Context NONE = new Context(null, null, null);
    private final Context parent;
    private final Object key;
    private final Object value;

    public Context(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.parent = null;
        this.key = key;
        this.value = value;
    }

    private Context(Context parent, Object key, Object value) {
        this.parent = parent;
        this.key = key;
        this.value = value;
    }

    public Context addData(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return new Context(this, key, value);
    }

    public Optional<Object> getData(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Context c = this;
        while (c != null) {
            if (key.equals(c.key)) {
                return Optional.of(c.value);
            }
            c = c.parent;
        }
        return Optional.empty();
    }
}

