/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.util.configuration.ConfigurationManager;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLogger {
    private final Logger logger;
    private static final int TRACE_LEVEL = 0;
    private static final int VERBOSE_LEVEL = 1;
    private static final int INFORMATIONAL_LEVEL = 2;
    private static final int WARNING_LEVEL = 3;
    private static final int ERROR_LEVEL = 4;
    private static final int DISABLED_LEVEL = 5;
    private static final int DEFAULT_LOG_LEVEL = 5;
    private int level = 5;
    private int configurationLevel;

    public ClientLogger(Class clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        this.logger = LoggerFactory.getLogger((String)className);
    }

    public ClientLogger asVerbose() {
        return this.asLevel(1);
    }

    public ClientLogger asInfo() {
        return this.asLevel(2);
    }

    public ClientLogger asWarning() {
        return this.asLevel(3);
    }

    public ClientLogger asError() {
        return this.asLevel(4);
    }

    public void log(String format, Object ... args) {
        if (this.canLogAtLevel(this.level)) {
            this.performLogging(format, args);
        }
    }

    private void performLogging(String format, Object ... args) {
        if (this.configurationLevel > 1) {
            args = this.attemptToRemoveThrowable(args);
        }
        switch (this.level) {
            case 1: {
                this.logger.debug(format, args);
                break;
            }
            case 2: {
                this.logger.info(format, args);
                break;
            }
            case 3: {
                this.logger.warn(format, args);
                break;
            }
            case 4: {
                this.logger.error(format, args);
                break;
            }
        }
    }

    private ClientLogger asLevel(int level) {
        if (this.canLogAtLevel(level)) {
            this.level = level;
        }
        return this;
    }

    private boolean canLogAtLevel(int level) {
        this.configurationLevel = ConfigurationManager.getConfiguration().get("AZURE_LOG_LEVEL", 5);
        if (level < this.configurationLevel) {
            return false;
        }
        switch (level) {
            case 1: {
                return this.logger != null && this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger != null && this.logger.isInfoEnabled();
            }
            case 3: {
                return this.logger != null && this.logger.isWarnEnabled();
            }
            case 4: {
                return this.logger != null && this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private Object[] attemptToRemoveThrowable(Object ... args) {
        if (args.length == 0) {
            return args;
        }
        Object potentialThrowable = args[args.length - 1];
        if (potentialThrowable instanceof Throwable) {
            return Arrays.copyOf(args, args.length - 1);
        }
        return args;
    }
}

