/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.ProxyOptions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.tcp.TcpClient;

class ReactorNettyClient
implements HttpClient {
    private reactor.netty.http.client.HttpClient httpClient;

    ReactorNettyClient() {
        this(reactor.netty.http.client.HttpClient.create());
    }

    private ReactorNettyClient(reactor.netty.http.client.HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private ReactorNettyClient(reactor.netty.http.client.HttpClient httpClient, Function<reactor.netty.http.client.HttpClient, reactor.netty.http.client.HttpClient> config) {
        this.httpClient = config.apply(httpClient);
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request) {
        Objects.requireNonNull(request.httpMethod());
        Objects.requireNonNull(request.url());
        Objects.requireNonNull(request.url().getProtocol());
        return ((HttpClient.RequestSender)this.httpClient.request(HttpMethod.valueOf((String)request.httpMethod().toString())).uri(request.url().toString())).send(ReactorNettyClient.bodySendDelegate(request)).responseConnection(ReactorNettyClient.responseDelegate(request)).single();
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> bodySendDelegate(HttpRequest restRequest) {
        return (reactorNettyRequest, reactorNettyOutbound) -> {
            for (HttpHeader header : restRequest.headers()) {
                if (header.value() == null) continue;
                reactorNettyRequest.header((CharSequence)header.name(), (CharSequence)header.value());
            }
            if (restRequest.body() != null) {
                Flux nettyByteBufFlux = restRequest.body().map(Unpooled::wrappedBuffer);
                return reactorNettyOutbound.send((Publisher)nettyByteBufFlux);
            }
            return reactorNettyOutbound;
        };
    }

    private static BiFunction<HttpClientResponse, Connection, Publisher<HttpResponse>> responseDelegate(HttpRequest restRequest) {
        return (reactorNettyResponse, reactorNettyConnection) -> Mono.just((Object)new ReactorNettyHttpResponse((HttpClientResponse)reactorNettyResponse, (Connection)reactorNettyConnection).request(restRequest));
    }

    @Override
    public final HttpClient proxy(Supplier<ProxyOptions> proxyOptionsSupplier) {
        return new ReactorNettyClient(this.httpClient, client -> client.tcpConfiguration(arg_0 -> ReactorNettyClient.lambda$null$3((Supplier)proxyOptionsSupplier, arg_0)));
    }

    @Override
    public final HttpClient wiretap(boolean enableWiretap) {
        return new ReactorNettyClient(this.httpClient, client -> client.wiretap(enableWiretap));
    }

    @Override
    public final HttpClient port(int port) {
        return new ReactorNettyClient(this.httpClient, client -> client.port(port));
    }

    private static /* synthetic */ TcpClient lambda$null$3(Supplier proxyOptionsSupplier, TcpClient c) {
        ProxyOptions options = (ProxyOptions)proxyOptionsSupplier.get();
        return c.proxy(ts -> ts.type(options.type().value()).address(options.address()));
    }

    private static class ReactorNettyHttpResponse
    extends HttpResponse {
        private final HttpClientResponse reactorNettyResponse;
        private final Connection reactorNettyConnection;

        ReactorNettyHttpResponse(HttpClientResponse reactorNettyResponse, Connection reactorNettyConnection) {
            this.reactorNettyResponse = reactorNettyResponse;
            this.reactorNettyConnection = reactorNettyConnection;
        }

        @Override
        public int statusCode() {
            return this.reactorNettyResponse.status().code();
        }

        @Override
        public String headerValue(String name) {
            return this.reactorNettyResponse.responseHeaders().get(name);
        }

        @Override
        public HttpHeaders headers() {
            HttpHeaders headers = new HttpHeaders();
            this.reactorNettyResponse.responseHeaders().forEach(e -> headers.put((String)e.getKey(), (String)e.getValue()));
            return headers;
        }

        @Override
        public Flux<ByteBuf> body() {
            return this.bodyIntern().doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            });
        }

        @Override
        public Mono<byte[]> bodyAsByteArray() {
            return this.bodyIntern().aggregate().asByteArray().doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            });
        }

        @Override
        public Mono<String> bodyAsString() {
            return this.bodyIntern().aggregate().asString().doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            });
        }

        @Override
        public Mono<String> bodyAsString(Charset charset) {
            return this.bodyIntern().aggregate().asString(charset).doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            });
        }

        @Override
        public void close() {
            if (!this.reactorNettyConnection.isDisposed()) {
                this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
            }
        }

        private ByteBufFlux bodyIntern() {
            return this.reactorNettyConnection.inbound().receive();
        }

        @Override
        Connection internConnection() {
            return this.reactorNettyConnection;
        }
    }
}

