/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlBuilder;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PortPolicy
implements HttpPipelinePolicy {
    private final int port;
    private final boolean overwrite;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortPolicy.class);

    public PortPolicy(int port, boolean overwrite) {
        this.port = port;
        this.overwrite = overwrite;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        UrlBuilder urlBuilder = UrlBuilder.parse(context.httpRequest().url());
        if (this.overwrite || urlBuilder.port() == null) {
            LOGGER.info("Changing port to {}", (Object)this.port);
            try {
                context.httpRequest().url(urlBuilder.port(this.port).toURL());
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        }
        return next.process();
    }
}

