/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedResponse;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PagedFlux<T>
extends Flux<T> {
    private final Supplier<Mono<PagedResponse<T>>> firstPageRetriever;
    private final Function<String, Mono<PagedResponse<T>>> nextPageRetriever;

    public PagedFlux(Supplier<Mono<PagedResponse<T>>> firstPageRetriever, Function<String, Mono<PagedResponse<T>>> nextPageRetriever) {
        Objects.requireNonNull(firstPageRetriever, "First page supplier cannot be null");
        Objects.requireNonNull(nextPageRetriever, "Next page retriever function cannot be null");
        this.firstPageRetriever = firstPageRetriever;
        this.nextPageRetriever = nextPageRetriever;
    }

    public Flux<PagedResponse<T>> byPage() {
        return this.firstPageRetriever.get().flatMapMany(this::extractAndFetchPage);
    }

    public Flux<PagedResponse<T>> byPage(String continuationToken) {
        return this.nextPageRetriever.apply(continuationToken).flatMapMany(this::extractAndFetchPage);
    }

    public void subscribe(CoreSubscriber<? super T> coreSubscriber) {
        this.byT(null).subscribe(coreSubscriber);
    }

    private Flux<T> byT(String continuationToken) {
        if (continuationToken == null) {
            return this.firstPageRetriever.get().flatMapMany(this::extractAndFetchT);
        }
        return this.nextPageRetriever.apply(continuationToken).flatMapMany(this::extractAndFetchT);
    }

    private Publisher<T> extractAndFetchT(PagedResponse<T> page) {
        String nextPageLink = page.nextLink();
        if (nextPageLink == null) {
            return Flux.fromIterable(page.items());
        }
        return Flux.fromIterable(page.items()).concatWith(this.byT(nextPageLink));
    }

    private Publisher<? extends PagedResponse<T>> extractAndFetchPage(PagedResponse<T> page) {
        String nextPageLink = page.nextLink();
        if (nextPageLink == null) {
            return Flux.just(page);
        }
        return Flux.just(page).concatWith(this.byPage(page.nextLink()));
    }
}

