/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.SwaggerMethodParser;
import com.azure.core.implementation.annotation.Host;
import com.azure.core.implementation.annotation.ServiceInterface;
import com.azure.core.implementation.exception.MissingRequiredAnnotationException;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.util.ImplUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SwaggerInterfaceParser {
    private final String host;
    private final String serviceName;
    private final Map<Method, SwaggerMethodParser> methodParsers = new HashMap<Method, SwaggerMethodParser>();

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter serializer) {
        this(swaggerInterface, serializer, null);
    }

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter serializer, String host) {
        if (!ImplUtils.isNullOrEmpty(host)) {
            this.host = host;
        } else {
            Host hostAnnotation = swaggerInterface.getAnnotation(Host.class);
            if (hostAnnotation != null && !hostAnnotation.value().isEmpty()) {
                this.host = hostAnnotation.value();
            } else {
                throw new MissingRequiredAnnotationException(Host.class, swaggerInterface);
            }
        }
        ServiceInterface serviceAnnotation = swaggerInterface.getAnnotation(ServiceInterface.class);
        if (serviceAnnotation == null || serviceAnnotation.name().isEmpty()) {
            throw new MissingRequiredAnnotationException(ServiceInterface.class, swaggerInterface);
        }
        this.serviceName = serviceAnnotation.name();
    }

    public SwaggerMethodParser methodParser(Method swaggerMethod) {
        SwaggerMethodParser result = this.methodParsers.get(swaggerMethod);
        if (result == null) {
            result = new SwaggerMethodParser(swaggerMethod, this.host());
            this.methodParsers.put(swaggerMethod, result);
        }
        return result;
    }

    String host() {
        return this.host;
    }

    String serviceName() {
        return this.serviceName;
    }
}

