/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.tracing;

import com.azure.core.implementation.tracing.Tracer;
import com.azure.core.util.Context;
import java.util.ServiceLoader;

public final class TracerProxy {
    private static ServiceLoader<? extends Tracer> tracers = ServiceLoader.load(Tracer.class);

    private TracerProxy() {
    }

    public static Context start(String methodName, Context context) {
        Context local = context;
        for (Tracer tracer : tracers) {
            local = tracer.start(methodName, local);
        }
        return local;
    }

    public static void setAttribute(String key, String value, Context context) {
        tracers.forEach(tracer -> tracer.setAttribute(key, value, context));
    }

    public static void end(int responseCode, Throwable error, Context context) {
        tracers.forEach(tracer -> tracer.end(responseCode, error, context));
    }

    public static Context setSpanName(String spanName, Context context) {
        Context local = context;
        for (Tracer tracer : tracers) {
            local = tracer.setSpanName(spanName, context);
        }
        return local;
    }
}

