/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.util.ExpandableStringEnum;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;

public final class PollResponse<T> {
    private final OperationStatus status;
    private final T value;
    private final Duration retryAfter;
    private final Map<Object, Object> properties;

    public PollResponse(OperationStatus status, T value, Duration retryAfter, Map<Object, Object> properties) {
        Objects.requireNonNull(status, "The status input parameter cannot be null.");
        this.status = status;
        this.value = value;
        this.retryAfter = retryAfter;
        this.properties = properties;
    }

    public PollResponse(OperationStatus status, T value, Duration retryAfter) {
        this(status, value, retryAfter, null);
    }

    public PollResponse(OperationStatus status, T value) {
        this(status, value, null);
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public T getValue() {
        return this.value;
    }

    public Duration getRetryAfter() {
        return this.retryAfter;
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public static final class OperationStatus
    extends ExpandableStringEnum<OperationStatus> {
        public static final OperationStatus NOT_STARTED = OperationStatus.fromString("NOT_STARTED");
        public static final OperationStatus IN_PROGRESS = OperationStatus.fromString("IN_PROGRESS");
        public static final OperationStatus SUCCESSFULLY_COMPLETED = OperationStatus.fromString("SUCCESSFULLY_COMPLETED");
        public static final OperationStatus FAILED = OperationStatus.fromString("FAILED");
        public static final OperationStatus USER_CANCELLED = OperationStatus.fromString("USER_CANCELLED");

        public static OperationStatus fromString(String name) {
            return OperationStatus.fromString(name, OperationStatus.class);
        }
    }
}

