/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credentials;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.implementation.util.Base64Util;
import com.azure.core.util.logging.ClientLogger;
import java.io.UnsupportedEncodingException;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public class BasicAuthenticationCredential
implements TokenCredential {
    private final ClientLogger logger = new ClientLogger(BasicAuthenticationCredential.class);
    private final String userName;
    private final String password;

    public BasicAuthenticationCredential(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    @Override
    public Mono<AccessToken> getToken(String ... scopes) {
        String encodedCredential;
        String credential = this.userName + ":" + this.password;
        try {
            encodedCredential = Base64Util.encodeToString(credential.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        return Mono.just((Object)new AccessToken(encodedCredential, OffsetDateTime.MAX));
    }
}

