/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;

public class HttpRequest
implements Serializable {
    private static final long serialVersionUID = 6338479743058758810L;
    private HttpMethod httpMethod;
    private URL url;
    private HttpHeaders headers;
    private Flux<ByteBuffer> body;

    public HttpRequest(HttpMethod httpMethod, URL url) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = new HttpHeaders();
    }

    public HttpRequest(HttpMethod httpMethod, URL url, HttpHeaders headers, Flux<ByteBuffer> body) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = headers;
        this.body = body;
    }

    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    public HttpRequest httpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public URL url() {
        return this.url;
    }

    public HttpRequest url(URL url) {
        this.url = url;
        return this;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public HttpRequest headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Flux<ByteBuffer> body() {
        return this.body;
    }

    public HttpRequest body(String content) {
        byte[] bodyBytes = content.getBytes(StandardCharsets.UTF_8);
        return this.body(bodyBytes);
    }

    public HttpRequest body(byte[] content) {
        this.headers.put("Content-Length", String.valueOf(content.length));
        return this.body((Flux<ByteBuffer>)Flux.defer(() -> Flux.just((Object)ByteBuffer.wrap(content))));
    }

    public HttpRequest body(Flux<ByteBuffer> content) {
        this.body = content;
        return this;
    }

    public HttpRequest buffer() {
        HttpHeaders bufferedHeaders = new HttpHeaders(this.headers);
        return new HttpRequest(this.httpMethod, this.url, bufferedHeaders, this.body);
    }
}

