/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CookiePolicy
implements HttpPipelinePolicy {
    private final ClientLogger logger = new ClientLogger(CookiePolicy.class);
    private final CookieHandler cookies = new CookieManager();

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            URI uri = context.httpRequest().url().toURI();
            HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
            for (HttpHeader header : context.httpRequest().headers()) {
                cookieHeaders.put(header.name(), Arrays.asList(context.httpRequest().headers().values(header.name())));
            }
            Map<String, List<String>> requestCookies = this.cookies.get(uri, cookieHeaders);
            for (Map.Entry<String, List<String>> entry : requestCookies.entrySet()) {
                context.httpRequest().headers().put(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
            }
            return next.process().map(httpResponse -> {
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                for (HttpHeader header : httpResponse.headers()) {
                    responseHeaders.put(header.name(), Collections.singletonList(header.value()));
                }
                try {
                    this.cookies.put(uri, responseHeaders);
                }
                catch (IOException e) {
                    throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
                }
                return httpResponse;
            });
        }
        catch (IOException | URISyntaxException e) {
            return Mono.error((Throwable)e);
        }
    }
}

