/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import reactor.core.publisher.Mono;

public class ProtocolPolicy
implements HttpPipelinePolicy {
    private final String protocol;
    private final boolean overwrite;
    private final ClientLogger logger = new ClientLogger(ProtocolPolicy.class);

    public ProtocolPolicy(String protocol, boolean overwrite) {
        this.protocol = protocol;
        this.overwrite = overwrite;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        UrlBuilder urlBuilder = UrlBuilder.parse(context.httpRequest().url());
        if (this.overwrite || urlBuilder.scheme() == null) {
            this.logger.info("Setting protocol to {}", this.protocol);
            try {
                context.httpRequest().url(urlBuilder.scheme(this.protocol).toURL());
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        }
        return next.process();
    }
}

