/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import reactor.core.publisher.Mono;

public class RetryPolicy
implements HttpPipelinePolicy {
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_DELAY = 0;
    private static final ChronoUnit DEFAULT_TIME_UNIT = ChronoUnit.MILLIS;
    private static final String RETRY_AFTER_MS_HEADER = "retry-after-ms";
    private final int maxRetries;
    private final Duration delayDuration;

    public RetryPolicy() {
        this.maxRetries = 3;
        this.delayDuration = Duration.of(0L, DEFAULT_TIME_UNIT);
    }

    public RetryPolicy(int maxRetries, Duration delayDuration) {
        this.maxRetries = maxRetries;
        this.delayDuration = delayDuration;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.attemptAsync(context, next, context.httpRequest(), 0);
    }

    private Mono<HttpResponse> attemptAsync(HttpPipelineCallContext context, HttpPipelineNextPolicy next, HttpRequest originalHttpRequest, int tryCount) {
        context.httpRequest(originalHttpRequest.buffer());
        return next.clone().process().flatMap(httpResponse -> {
            if (this.shouldRetry((HttpResponse)httpResponse, tryCount)) {
                return this.attemptAsync(context, next, originalHttpRequest, tryCount + 1).delaySubscription(this.determineDelayDuration((HttpResponse)httpResponse));
            }
            return Mono.just((Object)httpResponse);
        }).onErrorResume(err -> {
            if (tryCount < this.maxRetries) {
                return this.attemptAsync(context, next, originalHttpRequest, tryCount + 1).delaySubscription(this.delayDuration);
            }
            return Mono.error((Throwable)err);
        });
    }

    private boolean shouldRetry(HttpResponse response, int tryCount) {
        int code = response.statusCode();
        return tryCount < this.maxRetries && (code == 408 || code >= 500 && code != 501 && code != 505);
    }

    private Duration determineDelayDuration(HttpResponse response) {
        int code = response.statusCode();
        if (code != 429 && code != 503) {
            return this.delayDuration;
        }
        String retryHeader = response.headerValue(RETRY_AFTER_MS_HEADER);
        if (retryHeader == null || retryHeader.isEmpty()) {
            return this.delayDuration;
        }
        return Duration.ofMillis(Integer.parseInt(retryHeader));
    }
}

