/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.configuration.Configuration;
import com.azure.core.util.configuration.ConfigurationManager;
import reactor.core.publisher.Mono;

public class UserAgentPolicy
implements HttpPipelinePolicy {
    private static final String DEFAULT_USER_AGENT_HEADER = "azsdk-java";
    private static final String USER_AGENT_FORMAT = "azsdk-java-%s/%s %s";
    private static final String DISABLED_TELEMETRY_USER_AGENT_FORMAT = "azsdk-java-%s/%s";
    private static final String PLATFORM_INFO_FORMAT = "%s; %s %s";
    private final String userAgent;

    public UserAgentPolicy() {
        this(null);
    }

    public UserAgentPolicy(String userAgent) {
        this.userAgent = userAgent != null ? userAgent : DEFAULT_USER_AGENT_HEADER;
    }

    public UserAgentPolicy(String sdkName, String sdkVersion, Configuration configuration) {
        boolean telemetryDisabled = configuration.get("AZURE_TELEMETRY_DISABLED", false);
        this.userAgent = telemetryDisabled ? String.format(DISABLED_TELEMETRY_USER_AGENT_FORMAT, sdkName, sdkVersion) : String.format(USER_AGENT_FORMAT, sdkName, sdkVersion, UserAgentPolicy.getPlatformInfo());
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String header = context.httpRequest().headers().value("User-Agent");
        header = header == null || header.startsWith(DEFAULT_USER_AGENT_HEADER) ? this.userAgent : this.userAgent + " " + header;
        context.httpRequest().headers().put("User-Agent", header);
        return next.process();
    }

    private static String getPlatformInfo() {
        String javaVersion = ConfigurationManager.getConfiguration().get("java.version");
        String osName = ConfigurationManager.getConfiguration().get("os.name");
        String osVersion = ConfigurationManager.getConfiguration().get("os.version");
        return String.format(PLATFORM_INFO_FORMAT, javaVersion, osName, osVersion);
    }
}

