/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class DateTimeRfc1123 {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneId.of("UTC")).withLocale(Locale.US);
    private final OffsetDateTime dateTime;

    public DateTimeRfc1123(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTimeRfc1123(String formattedString) {
        this.dateTime = OffsetDateTime.parse(formattedString, DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    public OffsetDateTime dateTime() {
        if (this.dateTime == null) {
            return null;
        }
        return this.dateTime;
    }

    public String toString() {
        return RFC1123_DATE_TIME_FORMATTER.format(this.dateTime);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRfc1123)) {
            return false;
        }
        DateTimeRfc1123 rhs = (DateTimeRfc1123)obj;
        return this.dateTime.equals(rhs.dateTime());
    }
}

